/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.xmi;

import org.netbeans.api.xmi.*;
import org.netbeans.api.xmi.sax.*;
import org.xml.sax.*;

import javax.jmi.reflect.*;


public class Consumer extends XMIConsumer {

    private RefPackage extent = null;
    private XMIInputConfig config;
    private XmiSAXReader reader;
    
    // init .....................................................................
    
    public Consumer () {
        this (null);
    }
    
    public Consumer (XMIInputConfig cfg) {
        this.config = new InputConfig ();
        if (cfg != null)
            this.config.setReferenceResolver (cfg.getReferenceResolver ());
    }
    
    // methods ..................................................................
    
    public void setExtent(RefPackage extent) {
        this.extent = extent;
    }
    
    public RefPackage getExtent() {
        return extent;
    }
        
    public XMIInputConfig getConfiguration() {
        return config;
    }

    // ContentHadler implementation .............................................
    
    public void startDocument() throws SAXException {
        if (reader != null)
            throw new SAXException ("Consuming is in process, cannot start a new document.");
        if (extent == null)
            throw new SAXException ("No target extent is set.");
        reader = new XmiSAXReader (config);
        reader.initConsumer (extent);
    }
    
    public void endDocument() throws SAXException {
        check ();
        reader.endDocument ();
        reader = null;
    }
    
    public void characters(char[] ch, int start, int length) throws SAXException {
        check ();
        reader.characters (ch, start, length);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {        
        check ();
        reader.startElement (namespaceURI, localName, qName, atts);
    }
    
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        check ();
        reader.endElement (namespaceURI, localName, qName);
    }
    
    public void endPrefixMapping(String prefix) throws SAXException {
    }
          
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }
 
    public void processingInstruction(String target, String data) throws SAXException {
    }
    
    public void setDocumentLocator(Locator locator) {        
    }
    
    public void skippedEntity(String name) throws SAXException {
    }             
    
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    // helper methods ...........................................................
    
    private void check () throws SAXException {
        if (reader == null)
            throw new SAXException ("Consumer not started.");
    }
    
}
