/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query.mof;

import java.util.Comparator;

import javax.jmi.model.*;
import javax.jmi.reflect.RefFeatured;

import org.netbeans.lib.jmi.query.*;

/** Abstract class for creating filter queries.
 *
 * @author Petr Hrebejk
 */
public class FeatureFilter extends ValueFilter {
    
    /** Name of the feature to filter by */
    protected String featureName;
    
    /** Cache for the meta class and feature */
    private javax.jmi.model.Feature feature = null;
    private javax.jmi.model.MofClass metaClazz = null;
    
    public FeatureFilter(Query query, String featureName, Object value) {
        super( query, value );
        this.featureName = featureName;
    }
     
    public FeatureFilter(Query query, String featureName, Object value, Comparator comparator ) {
        super( query, value, comparator );
        this.featureName = featureName;
    }
    
    protected boolean accept( Object object ) {
        
        if ( object instanceof RefFeatured ) {
            resolveFeature( (RefFeatured)object );

            if ( feature == null ) {
                return false;
            }
            Object featureValue = ((RefFeatured)object).refGetValue( (javax.jmi.model.StructuralFeature) feature );


            return super.accept( featureValue );
        }
        else {
            return false;
        }
    }
    
    
    /** Finds the right feature for filtering, caches the information 
    * to perform quicker.
    */
    private void resolveFeature( RefFeatured refFeatured ) {
        javax.jmi.model.MofClass clazz = (javax.jmi.model.MofClass)refFeatured.refMetaObject();
        
        
        
        if ( metaClazz == null || !metaClazz.equals( clazz ) || feature != null) {
            metaClazz = null;
            feature = null;
            
            try {
                metaClazz = clazz;
               
                ModelElement me = clazz.lookupElementExtended( featureName ); 
                if ( me instanceof Feature ) {
                    feature = (Feature) me;
                }
            }
            catch( NameNotFoundException e ) {
                // Let feature be null
            }
        }
    }
    
}
