/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query;

import java.util.Iterator;


/** Default implementation of the iterator, does not allowe the remove operation
 *
 * @author Petr Hrebejk
 */
abstract class QueryIterator implements Iterator {

    abstract public boolean hasNext();
    
    abstract public Object next();
    
    /** Allways throws an UnsupportedOperationException as the Queries are
     * read only.
     */
    public void remove() {
        throw new UnsupportedOperationException( "MDR queries cannot be modified" );
    }
    
    // Innerclasses ------------------------------------------------------------
    
    /** Delegates to underlying iterator
    */
    static class Delegate extends QueryIterator {
        
        /** Contains the underlying iterator. Subclasses can ask it directly.
        */
        protected final Iterator ITERATOR;

        public Delegate(Iterator iterator) {
            super();
            this.ITERATOR = iterator;
        }

        public boolean hasNext() {
            return ITERATOR.hasNext();
        }

        public Object next() {
            return ITERATOR.next();
        }
        
    }
    
}
