/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdrant;

import java.io.File;
import java.io.FileOutputStream;

import javax.jmi.reflect.*;

import org.apache.tools.ant.BuildException;

import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.api.xmi.XMIWriter;

/** Exports given extent into XMI.
 *
 * @author  Petr Hrebejk
 */
public class WriteXMI extends MdrTask.Sub {
    
    private static final String DEFAULT_XMI_VERSION = "1.2";
    
    private File file; // File to read
    
    private String extent; // extent to read into
    
    private String xmiVersion;
    
    /** Creates a new instance of PrintExtentsNames */
    public WriteXMI() {
    }
    
    public void execute() throws Exception {
        
        if ( file == null ) {
            throw new BuildException( "Export file has to be sppecified. Use the \"file\" attribute" );
        }
        
        if ( extent == null ) {
            throw new BuildException( "Extent to export has to be sppecified. Use the \"extent\" attribute" );
        }
        
        if ( xmiVersion == null ) {
            xmiVersion = DEFAULT_XMI_VERSION;
        }
        
        XMIWriter xmiWriter = XMIWriterFactory.getDefault().createXMIWriter();
        xmiWriter.write( new FileOutputStream( file ), getRepository().getExtent( extent ), xmiVersion );
        
    }
    
    // ANT task attributes -----------------------------------------------------
    
    public void setFile( File file ) {
        this.file = file;
    }
    
    public void setExtent( String extent ) {
        this.extent = extent;
    }
    
    public void setXmiVersion( String xmiVersion ) {
        this.xmiVersion = xmiVersion;
    }
    
    
}
