/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdrant;

import java.io.File;

import javax.jmi.reflect.*;

import org.apache.tools.ant.BuildException;

import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReader;

/** Imports XMI file into given extent.
 *
 * @author  Petr Hrebejk
 */
public class ReadXMI extends MdrTask.Sub {
    
    private File file; // File to read
    
    private String extent; // exxtent to read into
    
    /** Creates a new instance of PrintExtentsNames */
    public ReadXMI() {
    }
    
    public void execute() throws Exception {
        
        if ( file == null ) {
            throw new BuildException( "Import file has to be sppecified. Use the \"file\" attribute" );
        }
        
        if ( extent == null ) {
            throw new BuildException( "Extent to import file in has to be sppecified. Use the \"extent\" attribute" );
            //getRepository().createExtent( name );
        }
        
        XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader();
        xmiReader.read( file.toURL().toString(), getRepository().getExtent( extent ) );
        
    }
    
    // ANT task attributes -----------------------------------------------------
    
    public void setFile( File file ) {
        this.file = file;
    }
    
    public void setExtent( String extent ) {
        this.extent = extent;
    }
    
    
}
