/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.util.*;

import java.util.*;
import java.io.*;

/**
 * JdbcSinglevaluedIndex implements the MDR SinglevaluedIndex interface 
 * using JDBC.
 *
 * @author John V. Sichi
 * @version $Id: JdbcSinglevaluedIndex.java,v 1.1.106.1 2006/07/01 05:19:21 jtulach Exp $
 */
class JdbcSinglevaluedIndex
    extends JdbcIndex implements SinglevaluedIndex
{
    protected LazyPreparedStatement sqlValuesIterator;
    protected LazyPreparedStatement sqlValuesSize;
    protected LazyPreparedStatement sqlValuesContains;
    protected LazyPreparedStatement sqlUpdate;
    
    protected void defineSql()
    {
        super.defineSql();

        sqlValuesIterator = new LazyPreparedStatement(
            "select " + valColName + " from " + tableName);
        
        sqlValuesSize = new LazyPreparedStatement(
            "select count(*) from " + tableName);
        
        sqlValuesContains = new LazyPreparedStatement(
            "select count(*) from " + tableName + " where "
            + valColName + " = ?");
        
        sqlUpdate = new LazyPreparedStatement(
            "update " + tableName + " set " + valColName
            + " = ? where " + keyColName + " = ?");
    }
    
    protected boolean isKeyUnique()
    {
        return true;
    }

    // implement SinglevaluedIndex
    public boolean put(Object key,Object value) throws StorageException
    {
        return putImpl(key,value);
    }
    
    protected boolean putImpl(Object key,Object value) throws StorageException
    {
        // REVIEW:  this optimizes for update rather than insert; could
        // use UPSERT on databases that support it
        int rowCount = storage.executeUpdate(
            sqlUpdate,new Object[]{value,key});
        // TODO:  assert rowCount == 0 or 1
        if (rowCount == 0) {
            // key did not exist; insert instead
            addImpl(key,value);
            return false;
        } else {
            // key existed and has already been updated
            return true;
        }
    }
    
    // implement SinglevaluedIndex
    public void replace(Object key, Object value)
        throws StorageException, StorageBadRequestException
    {
        replaceImpl(key,value);
    }
    
    protected void replaceImpl(Object key, Object value)
        throws StorageException, StorageBadRequestException
    {
        if (!putImpl(key,value)) {
            throw new StorageBadRequestException(
                "Cannot replace item that does not exist in the index.");
        }
    }
    
    // implement SinglevaluedIndex
    public Object get(Object key)
        throws StorageException, StorageBadRequestException
    {
        Object obj = getIfExists(key);
        if (obj == null) {
            throw new StorageBadRequestException ("Item not found: " + key);
        }
        return obj;
    }

    // implement SinglevaluedIndex
    public Object getObject(Object key, SinglevaluedIndex repos)
        throws StorageException
    {
        // NOTE: If JdbcPrimaryIndex did no caching, we could optimize this
        // with an SQL join.  But we can't join against the cache.  Same goes
        // for all of the other calls that take a repos argument.
        if (keyType == Storage.EntryType.MOFID) {
            return repos.get(get(key));
        } else {
            return get(key);
        }
    }

    // implement SinglevaluedIndex
    public Object getIfExists(Object key) throws StorageException
    {
        Iterator iter = storage.getResultSetIterator(
            sqlFind,new Object[]{key},getValueType());
        if (!iter.hasNext()) {
            return null;
        }
        return iter.next();
    }
    
    // implement SinglevaluedIndex
    public Object getObjectIfExists(Object key, SinglevaluedIndex repos)
        throws StorageException
    {
    	Object val = getIfExists(key);
        if (val == null) {
            return null;
        } else {
            if (keyType == Storage.EntryType.MOFID) {
                return repos.get(val);
            } else {
                return val;
            }
        }
    }

    // implement SinglevaluedIndex
    public Collection values()
        throws StorageException
    {
        return new JdbcCollection(
            storage,
            getValueType(),
            sqlValuesIterator,sqlValuesSize,sqlValuesContains);
    }
    
    // implement SinglevaluedIndex
    public Collection queryByKeyPrefix(
        Object prefix, SinglevaluedIndex repos) throws StorageException
    {
        // TODO:  optimize with LIKE
        throw new RuntimeException("oops, not yet implemented");
    }
}

// End JdbcSinglevaluedIndex.java
