/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.junit.output;

/**
 * Holds information about an <code>AntSession</code>.
 *
 * @author  Marian Petras
 * @see  JUnitAntLogger
 * @see  AntSession
 */
final class AntSessionInfo {

    /**
     * constant for &quot;uknown session type&quot;;
     * the value is <code>0</code> (zero)
     */
    static final int SESSION_TYPE_UNKNOWN = 0;
    /**
     * constant for &quot;JUnit test session&quot;;
     * the value is positive
     */
    static final int SESSION_TYPE_TEST = 2;
    /**
     * constant for &quot;JUnit test debugging session&quot;;
     * the value is positive
     */
    static final int SESSION_TYPE_DEBUG_TEST = 3;
    /**
     * constant for &quot;other session type&quot;;
     * the value is positive
     */
    static final int SESSION_TYPE_OTHER = 1;
    
    JUnitOutputReader outputReader = null;
    /** */
    private final long timeOfSessionStart;
    /**
     * type of the session - one of the <code>SESSION_TYPE_xxx</code> constants
     */
    int sessionType = SESSION_TYPE_UNKNOWN;
    
    /**
     */
    AntSessionInfo() {
        timeOfSessionStart = System.currentTimeMillis();
    }
    
    /**
     */
    long getTimeOfSessionStart() {
        return timeOfSessionStart;
    }
    
}
