/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * JUnitProgress.java
 *
 * Created on February 1, 2001, 7:30 PM
 */
package org.netbeans.modules.junit;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author  vstejskal
 */
public class JUnitProgress extends JPanel implements ActionListener {
    /** Creates new form JUnitProgress */
    public JUnitProgress(String dialogTitle) {
        if (dialogTitle != null) {
            this.dialogTitle = dialogTitle;
        }
        initComponents();
    }
    public void showMe(boolean displayCancel) {
        if (null == descriptor) {
            Object[]    options = null;
            Object      initOption = null;
            
            if (displayCancel) {
                options = new Object[] { DialogDescriptor.CANCEL_OPTION };
                initOption = DialogDescriptor.CANCEL_OPTION;
            }
            
            descriptor = new DialogDescriptor (
                this,
                dialogTitle,
                false,
                options,
                initOption, 
                DialogDescriptor.BOTTOM_ALIGN,
                null,
                this
            );
        }
        
        if (null != dialog)
            dialog.dispose();
        
        canceled = false;
        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(
                NbBundle.getMessage(JUnitProgress.class,
                                    "ACS_StatusBar_CreateTests"));      //NOI18N
        dialog.setSize(400, 150);
        dialog.setVisible(true);
    }
    
    public void hideMe() {
        if (null != dialog) {
            dialog.dispose();
        }
    }
    public void actionPerformed(ActionEvent ev) {
        canceled = true;
    }
    
    public void setMessage(final String msg) {
        setMessage(msg,false);
    }
    
    public void setMessage(final String msg, boolean displayStatus) {
        if (SwingUtilities.isEventDispatchThread())
            lblMessage.setText(msg);
        else {
            SwingUtilities.invokeLater(
                new Thread() {
                    public void run() {
                        lblMessage.setText(msg);
                    }
                }
            );
        }
        if (displayStatus) {
            displayStatusText(msg);
        }
    }
    
    public boolean isCanceled() {
        return canceled;
    }
    
    // not defined as static and defined in this class, because
    // it might show status also in the progress dialog in the future
    public void displayStatusText(String statusText) {
        StatusDisplayer.getDefault().setStatusText(statusText);
    }
    
    
    private DialogDescriptor    descriptor = null;
    private Dialog              dialog = null;
    private volatile boolean    canceled = false;
    private String              dialogTitle = "";
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lblMessage = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        lblMessage.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/junit/Bundle").getString("JUnitProgress.lblMessage.text"));
        lblMessage.setAlignmentX(0.5F);
        lblMessage.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(lblMessage, gridBagConstraints);

    }//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblMessage;
    // End of variables declaration//GEN-END:variables
}
