/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.util.ArrayList;

import javax.swing.JEditorPane;

import org.openide.src.JavaDocTag;

/** Panel with standard tags
 *
 * @author Petr Hrebejk
 * @version
 */

abstract class TagPanel extends javax.swing.JPanel {

    protected ArrayList htmlComponents = new ArrayList();

    private JavaDocEditorPanel editorPanel;

    TagPanel( JavaDocEditorPanel editorPanel ) {
        this.editorPanel = editorPanel;
    }

    abstract void setData( JavaDocTag tag );

    abstract String getCardName();

    abstract JavaDocTag getTag( String tagName );

    void addHTMLComponent( JEditorPane component ) {
        htmlComponents.add( component );
    }

    void handleFormatButton( String begTag, String endTag ) {
        for ( int i = 0; i < htmlComponents.size(); i++ ) {
            JEditorPane component = (JEditorPane)htmlComponents.get( i );
            if ( component.hasFocus() ) {

                int caretPosition = component.getCaretPosition();
                try {
                    component.getDocument().insertString( component.getSelectionStart(), begTag, null );
                    component.getDocument().insertString( component.getSelectionEnd(), endTag, null );
                    component.setCaretPosition( caretPosition + begTag.length() );
                }
                catch ( javax.swing.text.BadLocationException e ) {
                    //System.out.println(e );
                }   
                break;
            }
        }
    }

    void commitTagChange() {
        editorPanel.commitTagChange();
    }

    void enableHTMLButtons( boolean enable ) {
        editorPanel.enableButtons( enable );
    }

    abstract void grabFirstFocus();
}
