/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import org.openide.ErrorManager;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;
import org.netbeans.jmi.javamodel.*;

import javax.swing.text.BadLocationException;

/**
 *
 * @author
 * @version
 */
public class StandardTagPanel extends TagPanel implements JavaTagNames {

    private static final String cardName = "CRD_STANDARD"; // NOI18N

    private static final String[] classTags = {
        TAG_AUTHOR,
        TAG_DEPRECATED,
        TAG_SINCE,
        TAG_VERSION };

    private static final String[] fieldTags = {
        TAG_DEPRECATED,
        TAG_SERIAL,
        TAG_SINCE };

    private static final String[] methodTags = {
        TAG_DEPRECATED,
        TAG_RETURN,
        TAG_SERIALDATA,
        TAG_SINCE };



    static final long serialVersionUID =134652804415020896L;
    /** Initializes the Form */
    public StandardTagPanel ( JavaDocEditorPanel editorPanel ) {
        super( editorPanel );

        initComponents ( );
        jLabel2.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel2.text_Mnemonic").charAt(0));  // NOI18N
        jLabel1.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel1.text_Mnemonic").charAt(0));  // NOI18N

        addHTMLComponent( descriptionTextArea );
        editorPanel.registerComponent( descriptionTextArea );

        nameComboBox.getEditor().getEditorComponent().addFocusListener(
            new java.awt.event.FocusAdapter () {
                public void focusLost (java.awt.event.FocusEvent evt) {
                    commitTagChange();
                }
            });
        initAccessibility();
    }
        
    public StandardTagPanel( ClassMember element, JavaDocEditorPanel editorPanel ) {
        this( editorPanel );
        setElement( element );
    }

    public void setElement( ClassMember element ) {
        nameComboBox.removeAllItems();
        if ( element instanceof CallableFeature ) {
            for( int i = 0; i < methodTags.length; i++ ) {
                nameComboBox.addItem( methodTags[i] );
            }
            nameComboBox.setSelectedItem( "" ); // NOI18N
        }
        else if ( element instanceof Field || element instanceof Attribute) {
            for( int i = 0; i < fieldTags.length; i++ ) {
                nameComboBox.addItem( fieldTags[i] );
            }
            nameComboBox.setSelectedItem( "" ); // NOI18N
        }
        if ( element instanceof JavaClass ) {
            for( int i = 0; i < classTags.length; i++ ) {
                nameComboBox.addItem( classTags[i] );
            }
            nameComboBox.setSelectedItem( "" ); // NOI18N
        }
    }
    
    private void initAccessibility()
    {
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.jLabel2.textA11yDesc"));  // NOI18N
        nameComboBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.nameComboBox.textA11yName"));  // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.jLabel1.textA11yDesc"));  // NOI18N
        descriptionTextArea.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.descriptionTextArea.textA11yName"));  // NOI18N
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        nameComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        descriptionScrollPane = new javax.swing.JScrollPane();
        descriptionTextArea = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridBagLayout());

        jLabel2.setText(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel2.text"));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel2.setLabelFor(nameComboBox);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel2, gridBagConstraints);

        nameComboBox.setMaximumRowCount(4);
        nameComboBox.setToolTipText(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.nameComboBox.textA11yDesc"));
        nameComboBox.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(nameComboBox, gridBagConstraints);

        jLabel1.setText(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel1.text"));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(descriptionTextArea);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel1, gridBagConstraints);

        descriptionTextArea.setToolTipText(org.openide.util.NbBundle.getBundle(StandardTagPanel.class).getString("ACS_StandardTagPanel.descriptionTextArea.textA11yDesc"));
        descriptionTextArea.setContentType("text/html");
        descriptionTextArea.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusLost(evt);
            }
        });

        descriptionScrollPane.setViewportView(descriptionTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(descriptionScrollPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void descriptionTextAreaFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusGained
        enableHTMLButtons( true );
    }//GEN-LAST:event_descriptionTextAreaFocusGained


    private void descriptionTextAreaFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusLost
        enableHTMLButtons( false );
        commitTagChange();
    }//GEN-LAST:event_descriptionTextAreaFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane descriptionScrollPane;
    private javax.swing.JComboBox nameComboBox;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JEditorPane descriptionTextArea;
    // End of variables declaration//GEN-END:variables

    void setData( JavaDocTag tag ) {
        nameComboBox.getEditor().setItem( tag.name() );
        if ((tag.text() != null) && (! "".equals(tag.text().trim()))) { //NOI18N
            descriptionTextArea.setText( tag.text() );
        } else {
            try {
                descriptionTextArea.getDocument().remove(0, descriptionTextArea.getDocument().getLength());
            } catch (BadLocationException e) {
                ErrorManager.getDefault().annotate(e, "Failed to remove the text in the descriptionTextArea."); //NOI18N
            }
        }
    }

    JavaDocTag getTag( String tagName ) {
        return JavaDocSupport.createTag( (String) nameComboBox.getEditor().getItem(),
                                         descriptionTextArea.getText() );
    }

    String getCardName() {
        return cardName;
    }

    void grabFirstFocus() {
		// JHK 9/29/2000 - cause focus to default to description if the name combo box is filled
		if ( nameComboBox.getSelectedIndex() == -1 && nameComboBox.getSelectedItem().equals( "" ) ) //NOI18N
		    nameComboBox.requestFocus();
        else
	        descriptionTextArea.requestFocus();
        //nameComboBox.requestFocus();
    }
}
