/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import org.openide.ErrorManager;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;

import javax.swing.text.BadLocationException;

/**
 *
 * @author
 * @version
 */
public class SeeTagPanel extends TagPanel {

    private static final String cardName = "CRD_SEE"; // NOI18N


    static final long serialVersionUID =-6495497486819375562L;
    /** Initializes the Form */
    public SeeTagPanel( JavaDocEditorPanel editorPanel ) {
        super( editorPanel );

        initComponents ();
        jLabel1.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("CTL_SeeTagPanel.jLabel1.text_Mnemonic").charAt(0));  // NOI18N

        editorPanel.registerComponent( descriptionTextArea );

        addHTMLComponent( descriptionTextArea );
        initAccessibility();
    }
    
    private void initAccessibility()
    {
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.jLabel2.textA11yDesc"));  // NOI18N
        classTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.classTextField.textA11yName"));  // NOI18N
        jLabel3.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.jLabel3.textA11yDesc"));  // NOI18N
        memberTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.identifierTextField.textA11yName"));  // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.jLabel1.textA11yDesc"));  // NOI18N
        descriptionTextArea.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.tagTextArea.textA11yName"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        classTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        memberTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        descriptionScrollPane = new javax.swing.JScrollPane();
        descriptionTextArea = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridBagLayout());

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel2.setLabelFor(classTextField);
        jLabel2.setText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("CTL_SeeTagPanel.jLabel2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel2, gridBagConstraints);

        classTextField.setEditable(false);
        classTextField.setText("jTextField1");
        classTextField.setToolTipText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.classTextField.textA11yDesc"));
        classTextField.setEnabled(false);
        classTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nameTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(classTextField, gridBagConstraints);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel3.setLabelFor(memberTextField);
        jLabel3.setText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("CTL_SeeTagPanel.jLabel3.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel3, gridBagConstraints);

        memberTextField.setEditable(false);
        memberTextField.setText("jTextField2");
        memberTextField.setToolTipText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.identifierTextField.textA11yDesc"));
        memberTextField.setEnabled(false);
        memberTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(memberTextField, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(descriptionTextArea);
        jLabel1.setText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("CTL_SeeTagPanel.jLabel1.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel1, gridBagConstraints);

        descriptionTextArea.setToolTipText(org.openide.util.NbBundle.getBundle(SeeTagPanel.class).getString("ACS_SeeTagPanel.tagTextArea.textA11yDesc"));
        descriptionTextArea.setContentType("text/html");
        descriptionTextArea.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusLost(evt);
            }
        });

        descriptionScrollPane.setViewportView(descriptionTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(descriptionScrollPane, gridBagConstraints);

    }//GEN-END:initComponents

    private void descriptionTextAreaFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusGained
        enableHTMLButtons( true );
    }//GEN-LAST:event_descriptionTextAreaFocusGained

    private void descriptionTextAreaFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusLost
        enableHTMLButtons( false );
        commitTagChange();
    }//GEN-LAST:event_descriptionTextAreaFocusLost




    private void nameTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameTextFieldActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_nameTextFieldActionPerformed

    private void typeTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeTextFieldActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_typeTextFieldActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField memberTextField;
    private javax.swing.JEditorPane descriptionTextArea;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField classTextField;
    private javax.swing.JScrollPane descriptionScrollPane;
    // End of variables declaration//GEN-END:variables

    void setData( JavaDocTag tag ) {
        String description = tag.text().trim();
        if ((description != null) && (! "".equals(description))) {  //NOI18N
            descriptionTextArea.setText( description );
        } else {
            try {
                descriptionTextArea.getDocument().remove(0, descriptionTextArea.getDocument().getLength());
            } catch (BadLocationException e) {
                ErrorManager.getDefault().annotate(e, "Failed to remove the text in the descriptionTextArea."); //NOI18N
            }
        }
        //descriptionTextArea.setCaretPosition( 0 );
        classTextField.setText( ((JavaDocTag.See)tag).referencedClassName() );
        memberTextField.setText( ((JavaDocTag.See)tag).referencedMemberName() );
    }

    JavaDocTag getTag( String tagName ) {
        return JavaDocSupport.createSeeTag( tagName,
                                            descriptionTextArea.getText() );
    }

    String getCardName() {
        return cardName;
    }

    void grabFirstFocus() {
		// JHK 9/29/2000 - description since other fields are non-editable
        descriptionTextArea.requestFocus();
        //classTextField.requestFocus();
		//((java.awt.event.FocusListener)descriptionTextArea.getCaret()).focusLost( null );
    }
}
