/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.lang.reflect.InvocationTargetException;

import org.openide.nodes.PropertySupport;

/**
 *  This is a singleton supporting adding of properties for Java doc 
 *  comments into property sheet of java element nodes.
 * 
 *  @author Petr Hrebejk
 */
abstract class JavaDocPropertySupport extends PropertySupport {

    /** Constructs a new ElementProp - support for properties of
     * element hierarchy nodes.
     *
     * @param name The name of the property
     * @param type The class type of the property
     * @param canW The canWrite flag of the property
     */
    JavaDocPropertySupport( String name, java.lang.Class type, boolean canW ) {
        super(name, type,
              ResourceUtils.getBundledString("PROP_" + name),   //NOI18N
              ResourceUtils.getBundledString("HINT_" + name),   //NOI18N
              true, canW);

        setValue("canEditAsText", Boolean.FALSE); // NOI18N
    }

    public void setValue (Object val) throws IllegalArgumentException,
        IllegalAccessException, InvocationTargetException {
        if (!canWrite())
            throw new IllegalAccessException(ResourceUtils.getBundledString("MSG_Cannot_Write"));   //NOI18N
        // ignore otherwise
    }
}

    