/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.awt.CardLayout;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;
import javax.swing.DefaultListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.jmi.reflect.InvalidObjectException;

import org.openide.src.JavaDoc;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;
import org.openide.src.SourceException;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;

/**
 * @author phrebejk
 * @version
 */
public class JavaDocEditorPanel extends javax.swing.JPanel
    implements EnhancedCustomPropertyEditor {

    private JavaDoc javaDoc;
    private DefaultListModel listModel;
    private int lastSelection = -1;


    private EmptyTagPanel emptyTagPanel;
    private StandardTagPanel standardTagPanel;
    private SeeTagPanel seeTagPanel;
    private ParamTagPanel paramTagPanel;
    private ThrowsTagPanel throwsTagPanel;
    private SerialFieldTagPanel serialFieldTagPanel;

    private NewTagDialog newTagDialog;

    private AutoCommenter.Element element;

    private MnemonicsDistributor mnemonicsDistributor;

    static final long serialVersionUID =7005703844831686911L;
    /** Holds value of property dirty. */
    private boolean dirty;
    private boolean updatingTagList;
    private boolean grabFocusAfterNewButton = false;

    /** Creates new form JavaDocEditorPanel
     */
    public JavaDocEditorPanel() {
        initComponents ();

        // Buttons mnemonics
        newButton.setMnemonic( org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.newButton_Mnemonic").charAt(0) );    //NOI18N
        deleteButton.setMnemonic( org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.deleteButton_Mnemonic").charAt(0) );  //NOI18N
        moveUpButton.setMnemonic( org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveUpButton_Mnemonic").charAt(0) );  //NOI18N
        moveDownButton.setMnemonic( org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveDownButton_Mnemonic").charAt(0) );  //NOI18N
        boldButton.setMnemonic( NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.boldButton").charAt(0));
        italicButton.setMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.italicButton").charAt(0));
        underlineButton.setMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.underlineButton").charAt(0));
        codeButton.setMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.codeButton").charAt(0));
        preButton.setMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.preButton").charAt(0));
        linkButton.setMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.linkButton").charAt(0));

        commentLabel.setDisplayedMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.textPane").charAt(0));
        tagListLabel.setDisplayedMnemonic(NbBundle.getBundle(JavaDocEditorPanel.class).getString("MNEMO_JavaDocEditorPanel.tagPanel").charAt(0));

        enableButtons( false );

        mnemonicsDistributor = new MnemonicsDistributor();

        commentTextArea.setContentType( "text/html"); // NOI18N
        commentTextArea.getDocument().addDocumentListener(
            new DocumentListener() {
                public void changedUpdate( DocumentEvent evt) {
                    dirty = true;
                }
                public void insertUpdate( DocumentEvent evt) {
                    dirty = true;
                }
                public void removeUpdate( DocumentEvent evt) {
                    dirty = true;
                }
            } );
        mnemonicsDistributor.registerComponent( commentTextArea );



        // Make the list to select only one line and listen to selections

        tagList.setVisibleRowCount(4);
        tagList.getSelectionModel().setSelectionMode( javax.swing.ListSelectionModel.SINGLE_SELECTION );

        // i18n

        // Add panels for different tag types

        emptyTagPanel = new EmptyTagPanel( this );
        tagParamPanel.add( emptyTagPanel, emptyTagPanel.getCardName()  );

        standardTagPanel = new StandardTagPanel( this );
        tagParamPanel.add( standardTagPanel, standardTagPanel.getCardName() );

        seeTagPanel = new SeeTagPanel( this );
        tagParamPanel.add( seeTagPanel, seeTagPanel.getCardName() );


        paramTagPanel = new ParamTagPanel( this );
        tagParamPanel.add( paramTagPanel, paramTagPanel.getCardName() );

        throwsTagPanel = new ThrowsTagPanel( this );
        tagParamPanel.add( throwsTagPanel, throwsTagPanel.getCardName() );

        serialFieldTagPanel = new SerialFieldTagPanel( this );
        tagParamPanel.add( serialFieldTagPanel, serialFieldTagPanel.getCardName() );
        
        initAccessibility();
    }

    /**
     */
    public JavaDocEditorPanel(AutoCommenter.Element element, JavaDoc doc) {
        this();
        setElement(element);
        setJavaDoc(doc);
    }

    /**
     */
    public void clear() {
        commentTextArea.setText("");    //NOI18N
        newButton.setEnabled(false);
        setTagListModel();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        tagList.setEnabled(enable);
        commentTextArea.setEnabled(enable);
        newButton.setEnabled(enable);
    }

    public void updateForClosing() {
        commitTagChange();
    }

    private void setTagListModel() {
        lastSelection = -1;
        listModel = new DefaultListModel();
        tagList.setModel( listModel );
        deleteButton.setEnabled(false);
        moveUpButton.setEnabled(false);
        moveDownButton.setEnabled(false);
        listModel.addListDataListener(
            new ListDataListener() {
                public void intervalAdded(ListDataEvent e) {
                    dirty = true;
                }
                public void intervalRemoved(ListDataEvent e) {
                    dirty = true;
                }
                public void contentsChanged(ListDataEvent e) {
                    dirty = true;
                }
            } );
    }

    public void setJavaDoc(JavaDoc javaDoc) {
        this.javaDoc = javaDoc;

        if ( javaDoc != null ) {
            this.javaDoc = javaDoc;
            commentTextArea.setText( javaDoc.getText()  );
            commentTextArea.setCaretPosition(0);
        } else {
            commentTextArea.setText( null );
        }

        // Put the tags into listbox

        setTagListModel();

        if ( javaDoc != null ) {
            JavaDocTag tags[] = javaDoc.getTags();
            for( int i = 0; i < tags.length; i++ ) {
                listModel.addElement( tags[i] );
            }

            if ( listModel.getSize() < 0 ) {
                tagList.setSelectedIndex( 0 );
            }
        }

        // Add panels for different tag types

        try {
            standardTagPanel.setElement(element.getSrcElement());
            paramTagPanel.setElement(element.getSrcElement());
            throwsTagPanel.setElement(element.getSrcElement());
        } catch (InvalidObjectException e) {
            // ignore since AutoCommenter will refresh the model
        }

        setDirty(false);

        revalidate();
        repaint();
    }

    public void setElement(AutoCommenter.Element element) {
        this.element = element;
    }

    public AutoCommenter.Element getElement() {
        return this.element;
    }

    private void initAccessibility()
    {
        commentTextArea.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.commentTextAreaA11yName"));  // NOI18N
        tagList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.tagListA11yName"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        textPanel = new javax.swing.JPanel();
        commentScrollPane = new javax.swing.JScrollPane();
        commentTextArea = new javax.swing.JEditorPane();
        tagPanel = new javax.swing.JPanel();
        newButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        moveUpButton = new javax.swing.JButton();
        moveDownButton = new javax.swing.JButton();
        tagScrollPane = new javax.swing.JScrollPane();
        tagList = new javax.swing.JList();
        tagParamPanel = new javax.swing.JPanel();
        tagListLabel = new javax.swing.JLabel();
        htmlToolBar = new javax.swing.JPanel();
        boldButton = new javax.swing.JButton();
        italicButton = new javax.swing.JButton();
        underlineButton = new javax.swing.JButton();
        codeButton = new javax.swing.JButton();
        preButton = new javax.swing.JButton();
        linkButton = new javax.swing.JButton();
        commentLabel = new javax.swing.JLabel();

        FormListener formListener = new FormListener();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 0, 0));
        textPanel.setLayout(new java.awt.GridBagLayout());

        commentScrollPane.setMinimumSize(new java.awt.Dimension(22, 60));
        commentTextArea.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.commentTextAreaA11yDesc"));
        commentTextArea.setContentType("text/html");
        commentTextArea.addFocusListener(formListener);

        commentScrollPane.setViewportView(commentTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        textPanel.add(commentScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 7);
        add(textPanel, gridBagConstraints);

        tagPanel.setLayout(new java.awt.GridBagLayout());

        newButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.newButton.text"));
        newButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.newButton.textA11yDesc"));
        newButton.setMargin(new java.awt.Insets(2, 12, 2, 12));
        newButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        tagPanel.add(newButton, gridBagConstraints);

        deleteButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.deleteButton.text"));
        deleteButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.deleteButton.textA11yDesc"));
        deleteButton.setMargin(new java.awt.Insets(2, 12, 2, 12));
        deleteButton.setEnabled(false);
        deleteButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        tagPanel.add(deleteButton, gridBagConstraints);

        moveUpButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveUpButton.text"));
        moveUpButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.moveUpButton.textA11yDesc"));
        moveUpButton.setActionCommand("UP");
        moveUpButton.setMargin(new java.awt.Insets(2, 12, 2, 12));
        moveUpButton.setEnabled(false);
        moveUpButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 5, 0);
        tagPanel.add(moveUpButton, gridBagConstraints);

        moveDownButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.moveDownButton.text"));
        moveDownButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.moveDownButton.textA11yDesc"));
        moveDownButton.setActionCommand("DOWN");
        moveDownButton.setMargin(new java.awt.Insets(2, 12, 2, 12));
        moveDownButton.setEnabled(false);
        moveDownButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        tagPanel.add(moveDownButton, gridBagConstraints);

        tagList.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.tagListA11yDesc"));
        tagList.addListSelectionListener(formListener);

        tagScrollPane.setViewportView(tagList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 11);
        tagPanel.add(tagScrollPane, gridBagConstraints);

        tagParamPanel.setLayout(new java.awt.CardLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 5);
        tagPanel.add(tagParamPanel, gridBagConstraints);

        tagListLabel.setLabelFor(tagList);
        tagListLabel.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.tagPanel.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        tagPanel.add(tagListLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 11, 7);
        add(tagPanel, gridBagConstraints);

        htmlToolBar.setLayout(new java.awt.GridLayout(1, 6));

        boldButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.boldButton.text"));
        boldButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.boldButton.textA11yDesc"));
        boldButton.setActionCommand("B");
        boldButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        boldButton.setMinimumSize(new java.awt.Dimension(32, 27));
        boldButton.setRequestFocusEnabled(false);
        boldButton.addActionListener(formListener);

        htmlToolBar.add(boldButton);

        italicButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.italicButton.text"));
        italicButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.italicButton.textA11yDesc"));
        italicButton.setActionCommand("I");
        italicButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        italicButton.setMinimumSize(new java.awt.Dimension(32, 27));
        italicButton.setRequestFocusEnabled(false);
        italicButton.addActionListener(formListener);

        htmlToolBar.add(italicButton);

        underlineButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.underlineButton.text"));
        underlineButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.underlineButton.textA11yDesc"));
        underlineButton.setActionCommand("U");
        underlineButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        underlineButton.setMinimumSize(new java.awt.Dimension(32, 27));
        underlineButton.setRequestFocusEnabled(false);
        underlineButton.addActionListener(formListener);

        htmlToolBar.add(underlineButton);

        codeButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.codeButton.text"));
        codeButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.codeButton.textA11yDesc"));
        codeButton.setActionCommand("CODE");
        codeButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        codeButton.setMinimumSize(new java.awt.Dimension(32, 27));
        codeButton.setRequestFocusEnabled(false);
        codeButton.addActionListener(formListener);

        htmlToolBar.add(codeButton);

        preButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.preButton.text"));
        preButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.preButton.textA11yDesc"));
        preButton.setActionCommand("PRE");
        preButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        preButton.setMinimumSize(new java.awt.Dimension(32, 27));
        preButton.setRequestFocusEnabled(false);
        preButton.addActionListener(formListener);

        htmlToolBar.add(preButton);

        linkButton.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.linkButton.text"));
        linkButton.setToolTipText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("ACS_JavaDocEditorPanel.linkButton.textA11yDesc"));
        linkButton.setActionCommand("link");
        linkButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        linkButton.setMinimumSize(new java.awt.Dimension(32, 27));
        linkButton.setRequestFocusEnabled(false);
        linkButton.addActionListener(formListener);

        htmlToolBar.add(linkButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 7, 11, 7);
        add(htmlToolBar, gridBagConstraints);

        commentLabel.setLabelFor(commentTextArea);
        commentLabel.setText(org.openide.util.NbBundle.getBundle(JavaDocEditorPanel.class).getString("CTL_JavaDocEditorPanel.textPanel.title"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 3, 0, 0);
        add(commentLabel, gridBagConstraints);

    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener, java.awt.event.FocusListener, javax.swing.event.ListSelectionListener {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == newButton) {
                JavaDocEditorPanel.this.newTagButtonActionPerformed(evt);
            }
            else if (evt.getSource() == deleteButton) {
                JavaDocEditorPanel.this.delTagButtonActionPerformed(evt);
            }
            else if (evt.getSource() == moveUpButton) {
                JavaDocEditorPanel.this.moveTagButtonActionPerformed(evt);
            }
            else if (evt.getSource() == moveDownButton) {
                JavaDocEditorPanel.this.moveTagButtonActionPerformed(evt);
            }
            else if (evt.getSource() == boldButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
            else if (evt.getSource() == italicButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
            else if (evt.getSource() == underlineButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
            else if (evt.getSource() == codeButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
            else if (evt.getSource() == preButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
            else if (evt.getSource() == linkButton) {
                JavaDocEditorPanel.this.formatButtonActionPerformed(evt);
            }
        }

        public void focusGained(java.awt.event.FocusEvent evt) {
            if (evt.getSource() == commentTextArea) {
                JavaDocEditorPanel.this.commentTextAreaFocusGained(evt);
            }
        }

        public void focusLost(java.awt.event.FocusEvent evt) {
            if (evt.getSource() == commentTextArea) {
                JavaDocEditorPanel.this.commentTextAreaFocusLost(evt);
            }
        }

        public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
            if (evt.getSource() == tagList) {
                JavaDocEditorPanel.this.tagListValueChanged(evt);
            }
        }
    }
    // </editor-fold>//GEN-END:initComponents

    private void tagListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_tagListValueChanged
        if (!updatingTagList) {
            deleteButton.setEnabled(true);
            moveUpButton.setEnabled(true);
            moveDownButton.setEnabled(true);
        }

        TagPanel tagPanel;
        int sel = tagList.getMinSelectionIndex();

        if (lastSelection >= 0 && lastSelection != sel && lastSelection<listModel.getSize()) {
            JavaDocTag tag = (JavaDocTag)listModel.get( lastSelection );
            tagPanel = getPanelForTag( tag );
            JavaDocTag newTag = tagPanel.getTag( tag.name() );
            listModel.setElementAt(newTag, lastSelection);
        }
        lastSelection = sel;

        if ( sel < 0 ) {
            tagPanel = emptyTagPanel;
            enableButtons( false );
        }
        else {
            //JavaDocTag tag = (JavaDocTag)listModel.get( tagList.getMinSelectionIndex() ) ;
			JavaDocTag tag = (JavaDocTag)listModel.get( sel ) ;

            tagPanel = getPanelForTag( tag );
            tagPanel.setData( tag );
        }
        CardLayout layout = (CardLayout)tagParamPanel.getLayout();
        layout.show( tagParamPanel, tagPanel.getCardName() );
		// JHK 9/29/2000 - cause focus to go to entry fields when tag selection is changed
        // must check attributes of event since valueChanged is called so often even when the value is not really changed
        // Called when new tag is selected
        if ( tagPanel != emptyTagPanel && this.grabFocusAfterNewButton
                && evt.getFirstIndex() != evt.getLastIndex()
                && !evt.getValueIsAdjusting() ) {
            this.grabFocusAfterNewButton = false;
 			tagPanel.grabFirstFocus();
        }
        //System.out.println("In JavaDocEditorPanel.tagSelection: " + evt.toString() );
    }//GEN-LAST:event_tagListValueChanged

    private void commentTextAreaFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_commentTextAreaFocusLost
        enableButtons( false );
    }//GEN-LAST:event_commentTextAreaFocusLost

    private void commentTextAreaFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_commentTextAreaFocusGained
        enableButtons( true );
    }//GEN-LAST:event_commentTextAreaFocusGained

    private void newTagButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newTagButtonActionPerformed
        //if ( newTagDialog == null )   //what is that ? not possible, there can be different types of element
        newTagDialog = new NewTagDialog(element.getSrcElement());

        DialogDescriptor desc = new DialogDescriptor(newTagDialog,
                NbBundle.getMessage(JavaDocEditorPanel.class, "NewTagDialog.Form.title"),
                true, DialogDescriptor.OK_CANCEL_OPTION, DialogDescriptor.OK_OPTION, null);
        Object result = org.openide.DialogDisplayer.getDefault().notify(desc);
        JavaDocTag tag = null;

        if (result == DialogDescriptor.OK_OPTION && (tag = newTagDialog.getResult()) != null) {
            listModel.addElement( tag );
            tagList.ensureIndexIsVisible( listModel.getSize() );
            this.grabFocusAfterNewButton = true;
            tagList.setSelectedIndex( listModel.getSize() - 1 );
        }

    }//GEN-LAST:event_newTagButtonActionPerformed
    /** Deletes the actual row */
    private void delTagButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delTagButtonActionPerformed
        int sel = tagList.getMinSelectionIndex();

        if ( sel != -1 ) {
            lastSelection = -1;
            listModel.removeElementAt( sel );
        }

        if ( listModel.getSize() > 0 )
            tagList.setSelectedIndex( sel == listModel.getSize() ? sel - 1 : sel );
        else {
            CardLayout layout = (CardLayout)tagParamPanel.getLayout();
            layout.show( tagParamPanel, emptyTagPanel.getCardName() );
        }
    }//GEN-LAST:event_delTagButtonActionPerformed

    private void chgTagButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chgTagButtonActionPerformed
        commitTagChange();
    }//GEN-LAST:event_chgTagButtonActionPerformed


    private void moveTagButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveTagButtonActionPerformed
        // Add your handling code here:
        if ( evt.getActionCommand().equals( "UP" ) ) { // NOI18N
            int selIndex = tagList.getMinSelectionIndex();
            if ( selIndex > 0 ) {
                Object tag = listModel.get( selIndex );
                lastSelection = -1;
                listModel.removeElementAt( selIndex );
                listModel.insertElementAt( tag, selIndex - 1 );
                tagList.setSelectedIndex( selIndex - 1 );
            }
        }
        else if ( evt.getActionCommand().equals( "DOWN" ) ) { // NOI18N
            int selIndex = tagList.getMinSelectionIndex();
            if ( selIndex >= 0 && selIndex < listModel.getSize() - 1 ) {
                Object tag = listModel.get( selIndex );
                lastSelection = -1;
                listModel.removeElementAt( selIndex );
                listModel.insertElementAt( tag, selIndex + 1 );
                tagList.setSelectedIndex( selIndex + 1 );
            }
        }
    }//GEN-LAST:event_moveTagButtonActionPerformed

    private void formatButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_formatButtonActionPerformed
        String begTag;
        String endTag;
        String command = evt.getActionCommand();

        if ( command.equals( "link" ) ) { // NOI18N
            begTag = "{@link "; // NOI18N
            endTag = "}"; // NOI18N
        }
        else {
            begTag = "<" + command + ">"; // NOI18N
            endTag = "</" + command + ">"; // NOI18N
        }

        if ( commentTextArea.hasFocus() ) {
            int caretPosition = commentTextArea.getCaretPosition();
            /*
            StringBuffer sb = new StringBuffer( commentTextArea.getText() );
            sb.insert( commentTextArea.getSelectionStart(), begTag );
            sb.insert( commentTextArea.getSelectionEnd(), endTag  );
            commentTextArea.setText( sb.toString() );
            */
            try {
                commentTextArea.getDocument().insertString( commentTextArea.getSelectionStart(), begTag, null );
                commentTextArea.getDocument().insertString( commentTextArea.getSelectionEnd(), endTag, null );
                commentTextArea.setCaretPosition( caretPosition + 2 + evt.getActionCommand().length() );
            }
            catch ( javax.swing.text.BadLocationException e ) {
                //System.out.println(e );
            }
        }
        else {
            JavaDocTag tag = (JavaDocTag)listModel.get( tagList.getMinSelectionIndex() ) ;
            TagPanel tagPanel = getPanelForTag( tag );
            tagPanel.handleFormatButton( begTag, endTag );
        }
    }//GEN-LAST:event_formatButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton boldButton;
    private javax.swing.JButton codeButton;
    private javax.swing.JLabel commentLabel;
    private javax.swing.JScrollPane commentScrollPane;
    private javax.swing.JEditorPane commentTextArea;
    private javax.swing.JButton deleteButton;
    private javax.swing.JPanel htmlToolBar;
    private javax.swing.JButton italicButton;
    private javax.swing.JButton linkButton;
    private javax.swing.JButton moveDownButton;
    private javax.swing.JButton moveUpButton;
    private javax.swing.JButton newButton;
    private javax.swing.JButton preButton;
    private javax.swing.JList tagList;
    private javax.swing.JLabel tagListLabel;
    private javax.swing.JPanel tagPanel;
    private javax.swing.JPanel tagParamPanel;
    private javax.swing.JScrollPane tagScrollPane;
    private javax.swing.JPanel textPanel;
    private javax.swing.JButton underlineButton;
    // End of variables declaration//GEN-END:variables

    /** gets the text of comment */
    String getRawText() {
        JavaDoc jd = getUpdatedJavaDoc();
        return jd.getRawText();
    }
    
    JavaDoc getUpdatedJavaDoc() {
        JavaDoc jd = JavaDocSupport.createJavaDoc("");
        JavaDocTag tags[];

        try {
            jd.setText(commentTextArea.getDocument().getText( 0, commentTextArea.getDocument().getLength()));
            tags = new JavaDocTag[listModel.getSize()];
            listModel.copyInto(tags);
            jd.changeTags(tags,JavaDoc.SET);
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
        }
        return jd;
    }


    /**
    * @return Returns the property value that is result of the CustomPropertyEditor.
    * @exception IllegalStateException when the custom property editor does not represent valid property value
    *            (and thus it should not be set)
    */
    public Object getPropertyValue () throws IllegalStateException {

        try {
            javaDoc.setRawText( getRawText() );
        }
        catch ( SourceException ex ) {
            throw new IllegalStateException();

        }

        return javaDoc;
    }

    TagPanel getPanelForTag( JavaDocTag tag ) {

        if ( tag instanceof JavaDocTag.Param )
            return paramTagPanel;
        else if ( tag instanceof JavaDocTag.Throws )
            return throwsTagPanel;
        else if ( tag instanceof JavaDocTag.SerialField )
            return serialFieldTagPanel;
        else if ( tag instanceof JavaDocTag.See )
            return seeTagPanel;
        else
            return standardTagPanel;

    }

    /** Changes the tag in the tag list */
    void commitTagChange() {
        updatingTagList = true;
        TagPanel tagPanel;
        int sel = tagList.getMinSelectionIndex();
        if ( sel >= 0 ) {
            JavaDocTag tag = (JavaDocTag)listModel.get( sel );
            tagPanel = getPanelForTag( tag );
            JavaDocTag newTag = tagPanel.getTag( tag.name() );
            listModel.setElementAt( newTag, sel );
            dirty = true;
        }
        updatingTagList = false;
    }

    void enableButtons( boolean enable ) {
        boldButton.setEnabled( enable );
        italicButton.setEnabled( enable );
        underlineButton.setEnabled( enable );
        codeButton.setEnabled( enable );
        preButton.setEnabled( enable );
        linkButton.setEnabled( enable );
    }

    void registerComponent( java.awt.Component component) {
        mnemonicsDistributor.registerComponent( component );
    }


    /** Getter for property dirty.
     * @return Value of property dirty.
     */
    public boolean isDirty() {
        return dirty;
    }

    /** Setter for property dirty.
     * @param dirty Value of property dirty.
     */
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /** This innerclass serves as workaround for handling alt key mnemonics
     */
    class MnemonicsDistributor extends java.awt.event.KeyAdapter {

        MnemonicsDistributor() {
        }

        private static final int ALT_LESS_MASK = InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_GRAPH_DOWN_MASK |
                InputEvent.SHIFT_DOWN_MASK | InputEvent.META_DOWN_MASK;
        
        public void keyPressed( java.awt.event.KeyEvent e ) {

            javax.swing.KeyStroke ks = javax.swing.KeyStroke.getKeyStrokeForEvent( e );

            final int modifiers = ks.getModifiers();
            if ( ( modifiers & InputEvent.ALT_MASK ) != 0 && (modifiers & ALT_LESS_MASK) == 0) {

                switch ( ks.getKeyCode() ) {
                case  KeyEvent.VK_B:
                    boldButton.doClick();
                    e.consume();
                    break;
                case  KeyEvent.VK_I:
                    italicButton.doClick();
                    e.consume();
                    break;
                case  KeyEvent.VK_U:
                    underlineButton.doClick();
                    e.consume();
                    break;
                case  KeyEvent.VK_C:
                    codeButton.doClick();
                    e.consume();
                    break;
                case  KeyEvent.VK_P:
                    preButton.doClick();
                    e.consume();
                    break;
                case  KeyEvent.VK_L:
                    linkButton.doClick();
                    e.consume();
                    break;
                }
            }
        }

        void registerComponent( java.awt.Component component ) {
            component.addKeyListener(this);
        }

    }

}
