/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.awt.*;
import java.beans.*;
import org.openide.util.NbBundle;
import org.openide.src.JavaDoc;

/**
* A property editor for JavaDoc the simple version - no extra tags
*
* @version  0.10, 17 Jun 1998
*/
public final class JavaDocEditor extends PropertyEditorSupport  {

    // variables ..................................................................................

    private AutoCommenter.Element element;

//    private JavaDoc javaDoc;

    private JavaDocEditorPanel editorPanel = null;



    // init .......................................................................................

    public JavaDocEditor(AutoCommenter.Element element) {
        if (element == null) throw new NullPointerException("element"); // NOI18N
        this.element = element;
    }

    // main methods .......................................................................................

    public void setValue (Object object) {
        if (!(object instanceof JavaDoc))
            throw new IllegalArgumentException("object: " + object); // NOI18N
        
        super.setValue(object);
    }

    public String getAsText () {
        JavaDoc jd = (JavaDoc) getValue();
        String v = jd.getRawText();
        if (v == null) {
            return ResourceUtils.getBundledString("MSG_javadocCommentValue"); // NOI18N
        } else {
            return jd.getText();
        }
    }

    public void setAsText (String string)  {
        return;
    }

    public String getJavaInitializationString () {
        return null;
    }

    public String[] getTags () {
        return null;
    }

    public boolean isPaintable () {
        return false;
    }

    public void paintValue (Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor () {
        return true;
    }
    
    public Component getCustomEditor () {
        if (editorPanel == null) {
            editorPanel = new JavaDocEditorPanel(element, (JavaDoc) getValue());
            editorPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(JavaDocEditor.class).getString("ACS_JavaDocEditorPanelA11yName"));  // NOI18N
            editorPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(JavaDocEditor.class).getString("ACS_JavaDocEditorPanelA11yDesc"));  // NOI18N
        }
        return editorPanel;
    }

}
