/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javadoc.comments;

import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;

import javax.jmi.reflect.JmiException;
import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

/**
 * helpers over jmi api
 */
public final class JMIUtils {
    /**
     * Gets all classes recursively, both top-level and inner.
     * @param res java resource
     * @return all classes
     * @throws javax.jmi.reflect.JmiException
     */
    public static List/*<JavaClass>*/ getAllClasses(Resource res) throws JmiException {
        List/*<JavaClass>*/ l = new LinkedList/*<JavaClass>*/();
        Iterator/*<JavaClass>*/ it = res.getClassifiers().iterator();
        while (it.hasNext()) {
            addAllClasses((JavaClass) it.next(), l);
        }
        return l;
    }

    public static String multipartIdToName(MultipartId id) {
        LinkedList list = new LinkedList();
        while (id != null) {
            
            if (id.getTypeArguments().size() > 0) {
                return "java.lang.Object"; // NOI18N
            }
            
            list.addFirst(id.getName());
            id = id.getParent();
        }
        StringBuffer buf = new StringBuffer();
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            buf.append((String)iter.next());
            if (iter.hasNext())
                buf.append('.');
        }
        return buf.toString();
    }
    
    private static void addAllClasses(JavaClass jc, List/*<JavaClass>*/ container) throws JmiException {
        container.add(jc);
        Iterator it = jc.getFeatures().iterator();
        while (it.hasNext()) {
            Object feature = it.next();
            if (feature instanceof JavaClass) {
                addAllClasses((JavaClass) feature, container);
            }
        }
    }
    
}
