/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import javax.swing.SwingUtilities;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.netbeans.jmi.javamodel.*;

import javax.jmi.reflect.JmiException;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 * Corrects selected java source (or descendant) Javadoc.
 *
 * @author   Mauro Botelho
 */
public final class CorrectJavaDocAction extends NodeAction {
        
    static final long serialVersionUID =4989490116568783623L;

    public CorrectJavaDocAction () {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    /** Human presentable name of the action. This should be
     * presented as an item in a menu.
     * @return the name of the action
     */
    public String getName () {
        return NbBundle.getBundle( CorrectJavaDocAction.class ).getString("CTL_CORRECTJAVADOC_MenuItem");   //NOI18N
    }
    
    /** Help context where to find more about the action.
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx () {
        return new HelpCtx (CorrectJavaDocAction.class);
    }
    
    /** Enable this action only if it is really possible to correct the javadoc
     * for this element.
     */
    protected boolean enable( Node[] activatedNodes ) {
        if (activatedNodes.length != 1) {
            return false;
        }
        ClassMember element = (ClassMember) activatedNodes[0].getLookup().lookup(ClassMember.class);
        if (element == null) 
            return false;
        
        try {
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                if (!element.isValid()) {
                    return false;
                }
                AutoCommenter.Element jdElement = AutoCommenter.createAutoCommenterElement(element);
                if( jdElement == null ) //it is for example static initializer
                    return false;
        
                return jdElement.isCorrectable();
            } finally {
                JavaModel.getJavaRepository().endTrans();
            }
        } catch (JmiException e) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, e);
        }
        return false;
    }

    /** This method is called by one of the "invokers" as a result of
     * some user's action that should lead to actual "performing" of the action.
     * This default implementation calls the assigned actionPerformer if it
     * is not null otherwise the action is ignored.
     */
    public void performAction (final Node[] nodes ) {
        Runnable run = new Runnable() {
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    RequestProcessor.getDefault().post(this);
                    return ;
                }
                ClassMember element = (ClassMember) nodes[0].getLookup().lookup(ClassMember.class);
                if(element == null)
                    return;
                
                try {
                    JavaModel.getJavaRepository().beginTrans(true);
                    boolean fail = true;
                    try {
                        if (!element.isValid()) {
                            fail = false;
                            return;
                        }
                        AutoCommenter.Element jdElement = AutoCommenter.createAutoCommenterElement(element);
                        if (jdElement.isCorrectable()) {
                            jdElement.autoCorrect();
                        }
                        fail = false;
                    } finally {
                        JavaModel.getJavaRepository().endTrans(fail);
                    }
                } catch (JmiException e) {
                    ErrorManager.getDefault().notify(e);
                } catch (org.openide.src.SourceException e) {
                    ErrorManager.getDefault().notify(e);
                }
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, getName());
    }

    /**
     * no reason to run this in the AWT-event thread, moreover it touches MDR
     * @return <code>true</code>
     */ 
    protected boolean asynchronous() {
        return false;
    }
}    
