/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.io.*;
import java.awt.BorderLayout;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

import org.openide.windows.TopComponent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.nodes.Node;
import org.openide.loaders.DataObject;

/** Just a top component which contains AutoCommentPanel
 * @author  phrebejk
 * @version 
 */
public final class AutoCommentTopComponent
            extends TopComponent
            implements Externalizable
{
    
    static final String AUTO_COMMENT_HELP_CTX_KEY = "javadoc.auto.comment"; //NOI18N

    /** The only AutoCommentTopComponent allowed in the system */
    private static Reference acTopComponent;

    /** The panel contained by acTopComponent */
    private transient AutoCommentPanel acPanel;
    
    static final long serialVersionUID =3696398508351593122L;
    
    /** Creates new AutoCommentTopComponent */
    private AutoCommentTopComponent() {
        // Force winsys to not show tab when this comp is alone                                                                                                                 
        putClientProperty("TabPolicy", "HideWhenAlone"); // NOI18N
        setLayout( new BorderLayout() );
        add( acPanel = new AutoCommentPanel(), BorderLayout.CENTER );
    }

    void setAutoCommenter( AutoCommenter aCommenter ) {
        acPanel.setAutoCommenter( aCommenter );
        // Nodes[] nodes = aCommenter.getNodes();
        Node[] nodes = aCommenter.nodes;
        String className = null;
        if (nodes.length > 1 ) {
            className = NbBundle.getMessage(AutoCommentTopComponent.class, "CTL_AUTOCOMMENT_MultipleSources");   //NOI18N
        } else if (nodes.length == 1) {
            DataObject dobj = (DataObject) nodes[0].getLookup().lookup(DataObject.class);
            if (dobj != null) {
                className = dobj.getNodeDelegate().getDisplayName();
            } else {
                className = nodes[0].getDisplayName();
            }
        } else {
            className = ""; //NOI18N
        }
        setName(NbBundle.getMessage(AutoCommentTopComponent.class, "CTL_AUTOCOMMENT_WindowTitle") + " - " + className);  //NOI18N
    }

    protected void componentActivated() {
        super.componentActivated();
        acPanel.activate();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (this.isOpened()) {
            acPanel.deactivate();
        }
    }

    protected void componentClosed() {
        acPanel.deactivate();
        acPanel.setAutoCommenter(null);
        super.componentClosed();
    }

    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER;
    }
    
    protected String preferredID() {
        return "AutoCommentTopComponent"; // NOI18N
    }

    public static AutoCommentTopComponent getDefault() {
        AutoCommentTopComponent actp;
        if (acTopComponent == null || (actp = (AutoCommentTopComponent) acTopComponent.get()) == null) {

            actp = new AutoCommentTopComponent();
            actp.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_AutoCommentPanelA11yName"));  // NOI18N
            actp.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_AutoCommentPanelA11yDesc"));  // NOI18N
            actp.setName(ResourceUtils.getBundledString ("CTL_AUTOCOMMENT_WindowTitle") ); //NOI18N
            acTopComponent = new SoftReference(actp);
        } else {
            actp = (AutoCommentTopComponent) acTopComponent.get();
        }

        return actp;
    }

    public HelpCtx getHelpCtx () {
        return new HelpCtx (AUTO_COMMENT_HELP_CTX_KEY);
    }

    // Implementation of Externalizable -----------------------------------------
    
    /** Writes a resolvable */
    protected Object writeReplace() {
        return new Resolvable();
    }

    static class Resolvable implements java.io.Serializable {

        static final long serialVersionUID =8143238035030034549L;
        private Object readResolve() {            
            AutoCommentTopComponent actp = getDefault();
            actp.setAutoCommenter( new AutoCommenter());
            return actp;
        }
    }
}
