/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient;

import java.io.File;
import java.io.IOException;

/**
 * Set of utility methods.
 *
 * @author Petr Kuzel
 */
public class TestKit {
    public static File createTmpFolder(String prefix) throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");  // NOI18N
        File tmpFolder = new File(tmpDir);
        // generate unique name for tmp folder
        File tmp = File.createTempFile(prefix, "", tmpFolder);  // NOI18N
        if (tmp.delete() == false) {
            throw new IOException("Can not delete " + tmp);
        };
        if (tmp.mkdirs() == false) {
            throw new IOException("Can not create " + tmp);
        };
        return tmp;
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; i++) {
                File next = files[i];
                deleteRecursively(next);  // RECURSION
            }
            file.delete();
        }
    }
}
