/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient;

import junit.framework.TestCase;

import java.io.File;
import java.io.InputStream;

import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;

/**
 * Tescase covering handling network unreliability and
 * known server protocol errors (library contains workarounds).
 *
 * @author Petr Kuzel
 */
public class ErrorHandlingTest extends TestCase {

    /**
     * Test how client workarounds [server abort] signals.
     * <p>
     * Uses fake PseudoCvsServer.
     */
    public void test56552() throws Exception {

        File tmpDir = TestKit.createTmpFolder("serverAbortTest");
        String protocolLog = new File(tmpDir, "protocol").getAbsolutePath();
        System.setProperty("cvsClientLog", protocolLog);
        System.out.println(protocolLog);

        InputStream in = getClass().getResourceAsStream("protocol/iz56552.in");
        final PseudoCvsServer cvss = new PseudoCvsServer(in);
        new Thread(cvss).start();

        String cvsRoot = cvss.getCvsRoot();
        CVSRoot root = CVSRoot.parse(cvsRoot);
        final GlobalOptions gtx = new GlobalOptions();
        gtx.setCVSRoot(cvsRoot);
        Connection connection = new PServerConnection(root);
        final Client client = new Client(connection, new StandardAdminHandler());
        client.setLocalPath(tmpDir.getAbsolutePath());

        final StatusCommand status = new StatusCommand();
        File[] files = new File[] {new File(tmpDir, "placeholder")};
        status.setFiles(files);

        final Exception testException[] = new Exception[1];
        final boolean completedFlag[] = new boolean[] {false};
        Runnable run = new Runnable() {
            public void run() {
                try {
                    try {
                        client.executeCommand(status, gtx);
                        synchronized(completedFlag) {
                            completedFlag[0] = true;
                            completedFlag.notifyAll();
                        }
                    } finally {
                        cvss.stop();
                    }
                } catch (Exception ex) {
                    testException[0] = ex;
                }
            }
        };

        // test mus finish in reasonable time (compare to blocking forever that'd be a bug)

        Thread t = new Thread(run);
        t.start();
        synchronized(completedFlag) {
            if (completedFlag[0] == false) {
                completedFlag.wait(1000); // 'INFINITE' TIMEOUT
            }
        }
        t.interrupt();
        if (testException[0] != null) {
            throw testException[0];
        }
        assertTrue(completedFlag[0]);

        TestKit.deleteRecursively(tmpDir);
    }


}
