/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.util;

import java.io.*;

/**
 * A data output stream that also logs everything sent to a Writer (via the
 * logger).
 * @author  Robert Greig
 */
public class LoggedDataOutputStream extends FilterOutputStream {

    private long counter;

    /**
     * Construct a logged stream using the specified underlying stream
     * @param out the stream
     */
    public LoggedDataOutputStream(OutputStream out) {
        super(out);
    }

    /**
     * Write a line to the stream, logging it too. For compatibility reasons
     * only. Does exactly the same what writeBytes() does.
     *
     * @deprecated Line to to bytes conversion is host specifics.
     * Use raw byte access methods insted.
     *
     */
    public void writeChars(String line) throws IOException {
        writeBytes(line);
    }
    
    /**
     * Write a line to the stream, logging it too.
     *
     * Line to to bytes conversion is host specifics. Use {@link #writeBytes(String, String)} if possible.
     */
    public void writeBytes(String line) throws IOException {
        byte[] bytes = line.getBytes();
        out.write(bytes);
        Logger.logOutput(bytes);
        counter += bytes.length;
    }

    /**
     * Write a line to the stream, logging it too.
     */
    public void writeBytes(String line, String encoding) throws IOException {
        byte[] bytes = line.getBytes(encoding);
        out.write(bytes);
        Logger.logOutput(bytes);
        counter += bytes.length;
    }

    public void write(int b) throws IOException {
        super.write(b);
        counter++;
    }

    public void write(byte b[]) throws IOException {
        super.write(b);
        counter += b.length;
    }

    public void write(byte b[], int off, int len) throws IOException {
        super.write(b, off, len);
        counter += len;
    }

    /**
     * Closes this input stream and releases any system resources associated
     * with the stream.
     */
    public void close() throws IOException {
        out.close();
    }

    public OutputStream getUnderlyingStream() {
        return out;
    }

    public void setUnderlyingStream(OutputStream os) {
        out = os;
    }

    public long getCounter() {
        return counter;
    }
}