/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.*;

/**
 * interface for recognizing if the local files are to be ignored.
 * Implements the functionality of the .cvsignore files..
 *
 * @author  Milos Kleint
 */
public interface IgnoreFileFilter {

    /**
     * A file is checked against the patterns in the filter.
     * If any of these matches, the file should be ignored.
     *
     * @param directory is a file object that refers to the directory the file resides in.
     * @param noneCvsFile is the name of the file to be checked.
     */
    boolean shouldBeIgnored(File directory, String noneCvsFile);
}

