/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Thomas Singer.
 * Portions created by Thomas Singer are Copyright (C) 2001.
 * All Rights Reserved.
 *
 * Contributor(s): Thomas Singer.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.util;

import java.util.*;

/**
 * @author  Thomas Singer
 * @version Sep 26, 2001
 */
public class BundleUtilities {

    /**
     * Returns the package name of the specified class.
     * An empty String is returned, if the class is in the default package.
     */
    public static String getPackageName(Class clazz) {
        String fullClassName = clazz.getName();
        int lastDotIndex = fullClassName.lastIndexOf('.');
        if (lastDotIndex < 0) {
            return ""; // NOI18N
        }
        return fullClassName.substring(0, lastDotIndex);
    }

    /**
     * Returns the resourcename for the resource' shortName relative to the classInSamePackage.
     */
    public static String getResourceName(Class classInSamePackage, String shortName) {
        String packageName = getPackageName(classInSamePackage);
        String resourceName = packageName.replace('.', '/') + '/' + shortName;
        return resourceName;
    }

    /**
     * Returns the resource bundle for the specified resource' shortName relative to classInSamePackage.
     */
    public static ResourceBundle getResourceBundle(Class classInSamePackage, String shortName) {
        String resourceName = getResourceName(classInSamePackage, shortName);
        return ResourceBundle.getBundle(resourceName);
    }
}
