/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.
 *
 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.response;

import java.util.*;
import java.text.MessageFormat;

/**
 * Create response objects appropriate for handling different types of response
 * @author  Robert Greig
 */
public class ResponseFactory {
    
    private final Map responseInstancesMap;
    private String previousResponse = null;
    
    public ResponseFactory() {
        responseInstancesMap = new HashMap();
        responseInstancesMap.put("E", new ErrorMessageResponse()); //NOI18N
        responseInstancesMap.put("M", new MessageResponse()); //NOI18N
        responseInstancesMap.put("Mbinary", new MessageBinaryResponse()); //NOI18N
        responseInstancesMap.put("MT", new MessageTaggedResponse()); //NOI18N
        responseInstancesMap.put("Updated", new UpdatedResponse()); //NOI18N
        responseInstancesMap.put("Update-existing", new UpdatedResponse()); //NOI18N
        responseInstancesMap.put("Created", new CreatedResponse()); //NOI18N
        responseInstancesMap.put("Rcs-diff", new RcsDiffResponse()); //NOI18N
        responseInstancesMap.put("Checked-in", new CheckedInResponse()); //NOI18N
        responseInstancesMap.put("New-entry", new NewEntryResponse()); //NOI18N
        responseInstancesMap.put("ok", new OKResponse()); //NOI18N
        responseInstancesMap.put("error", new ErrorResponse()); //NOI18N
        responseInstancesMap.put("Set-static-directory", new SetStaticDirectoryResponse()); //NOI18N
        responseInstancesMap.put("Clear-static-directory", new ClearStaticDirectoryResponse()); //NOI18N
        responseInstancesMap.put("Set-sticky", new SetStickyResponse()); //NOI18N
        responseInstancesMap.put("Clear-sticky", new ClearStickyResponse()); //NOI18N
        responseInstancesMap.put("Valid-requests", new ValidRequestsResponse()); //NOI18N
        responseInstancesMap.put("Merged", new MergedResponse()); //NOI18N
        responseInstancesMap.put("Notified", new NotifiedResponse()); //NOI18N
        responseInstancesMap.put("Removed", new RemovedResponse()); //NOI18N
        responseInstancesMap.put("Remove-entry", new RemoveEntryResponse()); //NOI18N
        responseInstancesMap.put("Copy-file", new CopyFileResponse()); //NOI18N
        responseInstancesMap.put("Mod-time", new ModTimeResponse()); //NOI18N
        responseInstancesMap.put("Template", new TemplateResponse()); //NOI18N
        responseInstancesMap.put("Module-expansion", new ModuleExpansionResponse()); //NOI18N
        responseInstancesMap.put("Wrapper-rcsOption", new WrapperSendResponse()); //NOI18N
        
    }
    
    public Response createResponse(String responseName) {
        Response response = (Response)responseInstancesMap.get(responseName);
        if (response != null) {
            previousResponse = responseName;
            return response;
        }
        if (previousResponse != null && previousResponse.equals("M")) { //NOI18N
            return new MessageResponse(responseName);
        }
        previousResponse = null;
        IllegalArgumentException2 ex = new IllegalArgumentException2("Unhandled response: " + //NOI18N
                                              responseName + "."); //NOI18N

        // assemble reasonable localized message

        String cvsServer = System.getProperty("Env-CVS_SERVER");  // XXX defined under NB IDE only  // NOI18N
        if (cvsServer == null) {
            cvsServer = "";  // NOI18N
        } else {
            cvsServer = "=" + cvsServer; // NOI18N
        }

        String cvsExe = System.getProperty("Env-CVS_EXE");  // XXX defined under NB IDE only  // NOI18N
        if (cvsExe == null) {
            cvsExe = "";  // NOI18N
        } else {
            cvsExe = "=" + cvsExe; // NOI18N
        }

        ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.cvsclient.response.Bundle");  //NOI18N
        String msg = bundle.getString("BK0001");
        msg = MessageFormat.format(msg, new Object[] {responseName, cvsServer, cvsExe});
        ex.setLocalizedMessage(msg);
        throw ex;
    }

    private static class IllegalArgumentException2 extends IllegalArgumentException {

        private String localizedMessage;

        public IllegalArgumentException2(String s) {
            super(s);
        }

        public String getLocalizedMessage() {
            return localizedMessage;
        }

        private void setLocalizedMessage(String localizedMessage) {
            this.localizedMessage = localizedMessage;
        }


    }
}
