/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.response;

import java.io.*;

import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.util.*;

/**
 * Indicates that a file has been removed from the repository.
 * @author Robert Greig
 */
class RemovedResponse implements Response {
    
    /**
     * Process the data for the response.
     * @param dis the data inputstream allowing the client to read the server's
     * response. Note that the actual response name has already been read
     * and the input stream is positioned just before the first argument, if
     * any.
     */
    public void process(LoggedDataInputStream dis, ResponseServices services)
            throws ResponseException {
        try {
            String localPath = dis.readLine();
            String repositoryPath = dis.readLine();

            String filePath =
                    services.convertPathname(localPath, repositoryPath);
            filePath = new File(filePath).getAbsolutePath();
            if (services.getGlobalOptions().isExcluded(new File(filePath))) {
                return;
            }            

            FileToRemoveEvent e1 = new FileToRemoveEvent(this, filePath);
            FileRemovedEvent e2 = new FileRemovedEvent(this, filePath);

            //Fire the event before removing the local file. This is done
            //so that event listeners have a chance to access the file one 
            //last time before the file is removed.
            services.getEventManager().fireCVSEvent(e1);
            services.removeLocalFile(localPath, repositoryPath);
            services.getEventManager().fireCVSEvent(e2);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex,
                                        ResponseException.getLocalMessage(
                                            "CommandException.EndOfFile", // NOI18N
                                            null));
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    /**
     * Is this a terminal response, i.e. should reading of responses stop
     * after this response. This is true for responses such as OK or
     * an error response
     */
    public boolean isTerminalResponse() {
        return false;
    }
}
