/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.response;

import java.io.*;

import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * Handles binary message responses. Translate dthe reponse into
 * BinaryMessageEvents.
 *
 * @author  Martin Entlicher
 */
class MessageBinaryResponse implements Response {

    private static final int CHUNK_SIZE = 1024 * 256;  // 256Kb

    public MessageBinaryResponse() {
        // do nothing
    }
    
    /**
     * Process the data for the response.
     * @param dis the data inputstream allowing the client to read the server's
     * response. Note that the actual response name has already been read
     * and the inputstream is positioned just before the first argument, if any.
     */
    public void process(LoggedDataInputStream dis, ResponseServices services)
            throws ResponseException {
        try {
            String numBytesStr = dis.readLine();
            int numBytes;
            try {
                numBytes = Integer.parseInt(numBytesStr);
            } catch (NumberFormatException nfex) {
                throw new ResponseException(nfex);
            }
            int chunk = Math.min(numBytes, CHUNK_SIZE);
            byte[] bytes = new byte[chunk];
            while (numBytes > 0) {
                int len = dis.read(bytes, 0, chunk);
                if (len == -1) {
                    throw new ResponseException("EOF", ResponseException.getLocalMessage("CommandException.EndOfFile", null));  // NOI18N
                }
                numBytes -= len;
                chunk = Math.min(numBytes, CHUNK_SIZE); 
                BinaryMessageEvent event = new BinaryMessageEvent(this, bytes, len);
                services.getEventManager().fireCVSEvent(event);
            }
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, ResponseException.getLocalMessage("CommandException.EndOfFile", null)); //NOI18N
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    /**
     * Is this a terminal response, i.e. should reading of responses stop
     * after this response. This is true for responses such as OK or
     * an error response
     */
    public boolean isTerminalResponse() {
        return false;
    }
}