/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.response;

import java.io.*;

import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * Handles a message that the server requests is sent to stderr. Note that
 * this does not mean that an error occurred, only that the message is
 * to be sent to stderr.
 * @author  Robert Greig
 * @see org.netbeans.lib.cvsclient.response.ErrorResponse
 */
public final class ErrorMessageResponse implements Response {

    private boolean terminating;

    private String message;

    /**
     * Process the data for the response.
     * @param r the buffered reader allowing the client to read the server's
     * response. Note that the actual response name has already been read
     * and the reader is positioned just before the first argument, if any.
     */
    public void process(LoggedDataInputStream dis, ResponseServices services)
            throws ResponseException {
        try {
            final String line = dis.readLine();
            terminating |= line.endsWith(SpecialResponses.SERVER_ABORTED);
            terminating |= line.endsWith(SpecialResponses.SERVER_ABORTED_2);
            terminating |= line.endsWith(SpecialResponses.SERVER_ABORTED_3);
            terminating &= dis.available() == 0;  // heuristics to relax SpecialResponses in commit messages...
            message = line;
            MessageEvent event = new MessageEvent(this, line, true);
            services.getEventManager().fireCVSEvent(event);
        }
        catch (EOFException ex) {
            throw new ResponseException(ex, ResponseException.getLocalMessage("CommandException.EndOfFile", null)); //NOI18N
        }
        catch (IOException ex) {
            throw new ResponseException(ex);
        }
    }

    /** Is this a terminal response, i.e. should reading of responses stop
     * after this response. This is true for responses such as OK or
     * an error response
     */
    public boolean isTerminalResponse() {
        return terminating;
    }

    /**
     * Get the error message. 
     */
    public String getMessage() {
        return message;
    }

}
