/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.request;

/**
 * Implements the Sticky request
 * @author  Milos Kleint
 */
public final class StickyRequest extends Request {
    /**
     * The sticky tag/date to send
     */
    private String sticky;

    /**
     * Construct a new Sticky request
     * @param theStickyTag the sticky tag to use as an argument in the request
     */
    public StickyRequest(String theStickyTag) {
        sticky = theStickyTag;
    }

    /**
     * Get the request String that will be passed to the server
     * @return the request String
     */
    public String getRequestString() throws UnconfiguredRequestException {
        if (sticky == null) {
            throw new UnconfiguredRequestException(
                    "Sticky tag has not been set");
        }

        return "Sticky " + sticky + "\n"; //NOI18N
    }

    public void setStickyTag(String tag) {
        sticky = tag;
    }

    /**
     * Is a response expected from the server?
     * @return true if a response is expected, false if no response if
     * expected
     */
    public boolean isResponseExpected() {
        return false;
    }
}