/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.util.*;

/**
 * Tells the server about the eviroment variables to set for CVSROOT/*info executions.
 * @author  Milos Kleint
 */
public class SetRequest extends Request {
    
    private String keyValue;
    /**
     * Creates a new SetResponse with the key-value pair for one enviroment variable.
     */
    public SetRequest(String keyValue) {
        BugLog.getInstance().assertTrue(keyValue.indexOf('=') > 0, "Wrong SetRequest=" + keyValue);
        this.keyValue = keyValue;
    }
    /**
     * Get the request String that will be passed to the server
     * @return the request String
     * @throws UnconfiguredRequestException if the request has not been
     * properly configured
     */
    public String getRequestString() throws UnconfiguredRequestException {
        String toReturn = "Set " + keyValue + "\n"; //NOI18N
        return toReturn; //NOI18N
    }

    /**
     * Is a response expected from the server?
     * @return true if a response is expected, false if no response if
     * expected
     */
    public boolean isResponseExpected() {
        return false;
    }
}