/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.request;

import java.io.File;

/**
 * Represents <tt>Is-modified  filename \n</tt> request.
 * It's faster alternative to Modified but must be used with
 * care see protocol specs.
 *
 * @author Petr Kuzel
 */
public final class IsModifiedRequest extends Request {

    private final String fileName;

    public IsModifiedRequest(File file) {
        fileName = file.getName();
    }

    public String getRequestString() {
        return "Is-modified " + fileName + "\n";  // NOI18N
    }

    public boolean isResponseExpected() {
        return false;
    }
}
