/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.*;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author  Thomas Singer
 * @version Nov 17, 2001
 */
public class WindowsFileReadOnlyHandler
        implements FileReadOnlyHandler {
    // Implemented ============================================================

    /**
     * Makes the specified file read-only or writable, depending on the specified
     * readOnly flag.
     * @throws IOException if something gone wrong
     */
    public void setFileReadOnly(File file, boolean readOnly) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null"); // NOI18N
        }

        try {
            String[] arguments = {
                "attrib", // NOI18N
                readOnly ? "+r": "-r", // NOI18N
                file.getName()
            };
            Process process = Runtime.getRuntime().exec(arguments, null, file.getParentFile());
            process.waitFor();
        }
        catch (InterruptedException ex) {
            BugLog.getInstance().showException(ex);
        }
    }
}
