/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.file;

import java.io.*;

/**
 * A wrapper class that describes a file.
 * @author  Robert Greig
 */
public class FileDetails {
    /**
     * The file
     */
    private File file;

    /**
     * Whether the file is binary
     */
    private boolean isBinary;

    /**
     * Construct a FileDetails object
     * @param theFile the file
     * @param binary true if the file is binary, false if it is text
     */
    public FileDetails(File file, boolean isBinary) {
        this.file = file;
        this.isBinary = isBinary;
    }

    /**
     * Return the file.
     * @return the file
     */
    public File getFile() {
        return file;
    }

    /**
     * Return the file type.
     * @return true if the file is binary, false if it is text
     */
    public boolean isBinary() {
        return isBinary;
    }
}