/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.event;

/**
 * This event is really intended only for the use in the Checkout command.
 * During a checkout command, the client must ask the server to expand modules
 * to determine whether there are aliases defined for a particular module.
 * The client must then use the expansion to determine if a local directory
 * exists and if so, send appropriate Modified requests etc.
 * @author Robert Greig
 */
public class ModuleExpansionEvent extends CVSEvent {
    /**
     * The expanded module name
     */
    private String module;

    /**
     * Creates new ModuleExpansionEvent.
     * @param source the source of the event
     * @param theModule the module name that the original request has been
     * "expanded" to.
     */
    public ModuleExpansionEvent(Object source, String module) {
        super(source);
        this.module = module;
    }

    /**
     * Get the module name that the original module name has been expanded to.
     * @return the expanded name
     */
    public String getModule() {
        return module;
    }

    /**
     * Fire the event to the event listener. Subclasses should call the
     * appropriate method on the listener to dispatch this event.
     * @param listener the event listener
     */
    protected void fireEvent(CVSListener listener) {
        listener.moduleExpanded(this);
    }
}
