/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.event;

/**
 * An event sent from the server to indicate that a binary message should be
 * displayed to the user.
 * <p>
 * One protocol reponse mey be splitted into several messages.
 *
 * @author  Martin Entlicher
 */
public class BinaryMessageEvent extends CVSEvent {
    /**
     * Holds value of property message.
     */
    private byte[] message;

    private int len;

    /**
     * Construct a MessageEvent
     * @param source the source of the event
     * @param message the message text
     */
    public BinaryMessageEvent(Object source, byte[] message, int len) {
        super(source);
        this.message = message;
        this.len = len;
    }

    /**
     * Raw data buffer that holds binary data.
     * @return raw data buffer, its {@link #getMessageLength()} subset represents actual data
     */
    public byte[] getMessage() {
        return message;
    }

    /**
     * Defines valid data length in raw data buffer.
     * @return number of valid bytes in message raw data buffer.
     */
    public int getMessageLength() {
        return len;
    }

    /**
     * Fire the event to the event listener. Subclasses should call the
     * appropriate method on the listener to dispatch this event.
     * @param listener the event listener
     */
    protected void fireEvent(CVSListener listener) {
        listener.messageSent(this);
    }

}