/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.connection;

import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

import java.io.IOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

/**
 * Provides support for the :ext: connection method.
 * 
 * @author Maros Sandor
 */
public class ExtConnection extends AbstractConnection {
    
    private final String command;
    
    private Process process;

    /**
     * Creates new EXT connection method support class. Given command will be used for getting I/O
     * streams to CVS server. 
     * 
     * @param command command to execute
     */ 
    public ExtConnection(String command) {
        this.command = command;
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        try {
            process = Runtime.getRuntime().exec(command);
            setInputStream(new LoggedDataInputStream(new BufferedInputStream(process.getInputStream())));
            setOutputStream(new LoggedDataOutputStream(new BufferedOutputStream(process.getOutputStream())));
        } catch (IOException e) {
            throw new AuthenticationException(e, "Failed to execute: " + command);
        }
    }

    public void verify() throws AuthenticationException {
        try {
            open();
            verifyProtocol();
            process.destroy();
        } catch (Exception e) {
            throw new AuthenticationException(e, "Failed to execute: " + command);
        }
    }

    public void close() throws IOException {
        if (isOpen()) {
            process.destroy();
        }
    }

    public boolean isOpen() {
        if (process == null) return false;
        try {
            process.exitValue();
            return false;
        } catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getPort() {
        return 0;
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(getOutputStream());
    }
}
