/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.commandLine;

import java.io.*;

import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.event.*;

/**
 * A basic implementation of a CVS listener. Is really only interested in
 * message events. This listener is suitable for command line clients and
 * clients that don't "persist".
 * @author  Robert Greig
 */
public class BasicListener extends CVSAdapter {
    private final StringBuffer taggedLine = new StringBuffer();
    private PrintStream stdout;
    private PrintStream stderr;
    
    public BasicListener() {
        this(System.out, System.err);
    }
    
    public BasicListener(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    /**
     * Called when the server wants to send a message to be displayed to
     * the user. The message is only for information purposes and clients
     * can choose to ignore these messages if they wish.
     * @param e the event
     */
    public void messageSent(MessageEvent e) {
        String line = e.getMessage();
        if (e instanceof EnhancedMessageEvent) {
            return ;
        }
        PrintStream stream = e.isError() ? stderr : stdout;

        if (e.isTagged()) {
            String message = MessageEvent.parseTaggedMessage(taggedLine, e.getMessage());
            if (message != null) {
                stream.println(message);
            }
        }
        else {
            stream.println(line);
        }
    }

    /**
     * Called when the server wants to send a binary message to be displayed to
     * the user. The message is only for information purposes and clients
     * can choose to ignore these messages if they wish.
     * @param e the event
     */
    public void messageSent(BinaryMessageEvent e) {
        byte[] bytes = e.getMessage();
        int len = e.getMessageLength();
        stdout.write(bytes, 0, len);
    }

    /**
     * Called when file status information has been received
     */
    public void fileInfoGenerated(FileInfoEvent e) {
//      FileInfoContainer fileInfo = e.getInfoContainer();
//        if (fileInfo.getClass().equals(StatusInformation.class)) {
//          System.err.println("A file status event was received.");
//          System.err.println("The status information object is: " +
//                             fileInfo);
//        }
    }
}