/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import org.openide.util.NbBundle;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;

/**
 * Excludes selected nodes from commit.
 * 
 * @author Maros Sandor
 */
public class ExcludeFromCommitAction extends AbstractAction {

    public ExcludeFromCommitAction() {
        int status = getActionStatus();
        if (status == 1 || status == -1) {
            putValue(Action.NAME, NbBundle.getBundle(ExcludeFromCommitAction.class).getString("CTL_Synchronize_Popup_ExcludeFromCommit"));
        } else {
            putValue(Action.NAME, NbBundle.getBundle(ExcludeFromCommitAction.class).getString("CTL_Synchronize_Popup_IncludeInCommit"));
        }
        setEnabled(status != -1);
    }
    
    private int getActionStatus() {
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        File [] files = Utils.getCurrentContext(null).getFiles();
        int status = -1;
        for (int i = 0; i < files.length; i++) {
            if (config.isExcludedFromCommit(files[i].getAbsolutePath())) {
                if (status == 1) return -1;
                status = 2;
            }
            else {
                if (status == 2) return -1;
                status = 1;
            }
        }
        return status;
    }

    public void actionPerformed(ActionEvent e) {
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        int status = getActionStatus();
        File [] files = Utils.getCurrentContext(null).getFiles();
        if (status == 1) {
            for (int i = 0; i < files.length; i++) {
                File file = files[i];
                config.addExclusionPath(file.getAbsolutePath());
            }
        } else if (status == 2) {
            for (int i = 0; i < files.length; i++) {
                File file = files[i];
                config.removeExclusionPath(file.getAbsolutePath());
            }
        }
    }
}
