/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import javax.swing.text.PlainDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

/**
 * UI for connection proxy configuration.
 *
 * @author  Petr Kuzel
 */
final class ProxyConfigurationPanel extends javax.swing.JPanel implements java.awt.event.ActionListener {
    
    /** Creates new form RepositoryPanel */
    public ProxyConfigurationPanel() {
        initComponents();
        portTextField.setDocument(new PortDocument());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        setLayout(new java.awt.GridBagLayout());

        typeButtonGroup.add(systemProxyRadioButton);
        systemProxyRadioButton.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(systemProxyRadioButton, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1001"));
        systemProxyRadioButton.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseSystemProxy"));
        systemProxyRadioButton.addActionListener(this);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        add(systemProxyRadioButton, gridBagConstraints);

        typeButtonGroup.add(directRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(directRadioButton, org.openide.util.NbBundle.getBundle(ProxyConfigurationPanel.class).getString("BK1009"));
        directRadioButton.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseNoProxy"));
        directRadioButton.addActionListener(this);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(directRadioButton, gridBagConstraints);

        typeButtonGroup.add(httpProxyRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(httpProxyRadioButton, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1002"));
        httpProxyRadioButton.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseHttpsProxy"));
        httpProxyRadioButton.addActionListener(this);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(httpProxyRadioButton, gridBagConstraints);

        typeButtonGroup.add(socksProxyRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(socksProxyRadioButton, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1003"));
        socksProxyRadioButton.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseSocksProxy"));
        socksProxyRadioButton.addActionListener(this);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(socksProxyRadioButton, gridBagConstraints);

        serverLabel.setLabelFor(serverTextField);
        org.openide.awt.Mnemonics.setLocalizedText(serverLabel, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1004"));
        serverLabel.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_ProxyHost"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(serverLabel, gridBagConstraints);

        serverTextField.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 20.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(serverTextField, gridBagConstraints);

        portLabel.setLabelFor(portTextField);
        org.openide.awt.Mnemonics.setLocalizedText(portLabel, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1005"));
        portLabel.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_ProxyPort"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(portLabel, gridBagConstraints);

        portTextField.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 0);
        add(portTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(loginCheckBox, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1006"));
        loginCheckBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_ProxyLogin"));
        loginCheckBox.addActionListener(this);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(loginCheckBox, gridBagConstraints);

        nameLabel.setLabelFor(nameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(nameLabel, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1007"));
        nameLabel.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_ProxyUsername"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 24, 3, 3);
        add(nameLabel, gridBagConstraints);

        nameTextField.setColumns(20);
        nameTextField.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 20.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(nameTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 5.0;
        add(jPanel2, gridBagConstraints);

        passwordLabel.setLabelFor(passwordTextField);
        org.openide.awt.Mnemonics.setLocalizedText(passwordLabel, org.openide.util.NbBundle.getMessage(ProxyConfigurationPanel.class, "BK1008"));
        passwordLabel.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_ProxyPassword"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 24, 3, 3);
        add(passwordLabel, gridBagConstraints);

        passwordTextField.setColumns(20);
        passwordTextField.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 20.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(passwordTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 5.0;
        add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == systemProxyRadioButton) {
            ProxyConfigurationPanel.this.systemProxyRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == directRadioButton) {
            ProxyConfigurationPanel.this.directRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == httpProxyRadioButton) {
            ProxyConfigurationPanel.this.httpProxyRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == socksProxyRadioButton) {
            ProxyConfigurationPanel.this.socksProxyRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == loginCheckBox) {
            ProxyConfigurationPanel.this.loginCheckBoxActionPerformed(evt);
        }
    }
    // </editor-fold>//GEN-END:initComponents

    private void directRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_directRadioButtonActionPerformed
        enableServerPart(directRadioButton.isSelected() == false);
    }//GEN-LAST:event_directRadioButtonActionPerformed

    private void socksProxyRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_socksProxyRadioButtonActionPerformed
        enableServerPart(socksProxyRadioButton.isSelected());
    }//GEN-LAST:event_socksProxyRadioButtonActionPerformed

    private void httpProxyRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_httpProxyRadioButtonActionPerformed
        enableServerPart(httpProxyRadioButton.isSelected());
    }//GEN-LAST:event_httpProxyRadioButtonActionPerformed

    private void systemProxyRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_systemProxyRadioButtonActionPerformed
        enableServerPart(systemProxyRadioButton.isSelected() == false);
    }//GEN-LAST:event_systemProxyRadioButtonActionPerformed

    private void loginCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loginCheckBoxActionPerformed
        enableProxyAuthPart(loginCheckBox.isSelected());        
    }//GEN-LAST:event_loginCheckBoxActionPerformed

    void enableServerPart(boolean enable) {
        serverLabel.setEnabled(enable);
        serverTextField.setEnabled(enable);
        serverTextField.setEditable(enable);
        loginCheckBox.setEnabled(enable);
        portLabel.setEnabled(enable);
        portTextField.setEnabled(enable);
        portTextField.setEditable(enable);
        enableProxyAuthPart(enable && loginCheckBox.isSelected());
    }

    private void enableProxyAuthPart(boolean enable) {
        nameLabel.setEnabled(enable);
        nameTextField.setEnabled(enable);
        passwordLabel.setEnabled(enable);
        passwordTextField.setEnabled(enable);                        
    }

     static class PortDocument extends PlainDocument {

         public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {

             if (str == null) return;

             char[] upper = str.toCharArray();
             for (int i = 0; i < upper.length; i++) {
                 if ("1234567890".indexOf(upper[i]) == -1) {  // NOI18N
                     return;
                 }
             }
             super.insertString(offs, new String(upper), a);
         }
     }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JRadioButton directRadioButton = new javax.swing.JRadioButton();
    final javax.swing.JRadioButton httpProxyRadioButton = new javax.swing.JRadioButton();
    final javax.swing.JPanel jPanel1 = new javax.swing.JPanel();
    final javax.swing.JPanel jPanel2 = new javax.swing.JPanel();
    final javax.swing.JPanel jPanel3 = new javax.swing.JPanel();
    final javax.swing.JCheckBox loginCheckBox = new javax.swing.JCheckBox();
    final javax.swing.JLabel nameLabel = new javax.swing.JLabel();
    final javax.swing.JTextField nameTextField = new javax.swing.JTextField();
    final javax.swing.JLabel passwordLabel = new javax.swing.JLabel();
    final javax.swing.JPasswordField passwordTextField = new javax.swing.JPasswordField();
    final javax.swing.JLabel portLabel = new javax.swing.JLabel();
    final javax.swing.JFormattedTextField portTextField = new javax.swing.JFormattedTextField();
    final javax.swing.JLabel serverLabel = new javax.swing.JLabel();
    final javax.swing.JTextField serverTextField = new javax.swing.JTextField();
    final javax.swing.JRadioButton socksProxyRadioButton = new javax.swing.JRadioButton();
    final javax.swing.JRadioButton systemProxyRadioButton = new javax.swing.JRadioButton();
    final javax.swing.ButtonGroup typeButtonGroup = new javax.swing.ButtonGroup();
    // End of variables declaration//GEN-END:variables
    
}
