/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.modules.versioning.system.cvss.*;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;

/**
 * Executes 'cvs update -d -P' on all open projects.
 * 
 * @author Maros Sandor
 */
public class UpdateProjectsAction extends SystemAction {

    public UpdateProjectsAction() {
        setIcon(null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }

    public String getName() {
        return NbBundle.getMessage(UpdateProjectsAction.class, "CTL_MenuItem_UpdateProjects"); // NOI18N
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UpdateProjectsAction.class);
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            Project projects[] = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; i++) {
                Project project = projects[i];
                if (Utils.isVersionedProject(project)) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public void actionPerformed(ActionEvent ev) {
        setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable() {
            public void run() {
                async();
            }
        });
    }

    private void async() {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(UpdateProjectsAction.class, "BK0002"));
        try {
            group.progress(NbBundle.getMessage(UpdateProjectsAction.class, "BK0003"));

            Project [] projects = OpenProjects.getDefault().getOpenProjects();
            Context ctx = Utils.getProjectsContext(projects);

            if (ctx.getRootFiles().length == 0) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(UpdateProjectsAction.class, "MSG_NoProjectFiles_Prompt"),
                        NbBundle.getMessage(UpdateProjectsAction.class, "MSG_NoProjectFiles_Title"), JOptionPane.INFORMATION_MESSAGE);
                return;
            }

            GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
            if (ctx.getExclusions().size() > 0) {
                options.setExclusions((File[]) ctx.getExclusions().toArray(new File[ctx.getExclusions().size()]));
            }
            UpdateCommand cmd = new UpdateCommand();
            cmd.setDisplayName(NbBundle.getMessage(UpdateProjectsAction.class, "BK0002"));
            cmd.setFiles(ctx.getRootFiles());
            cmd.setBuildDirectories(true);
            cmd.setPruneDirectories(true);

            group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options));
            group.execute();
        } finally {
            setEnabled(true);
            group.executed();
        }
    }
}
