/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions;

import org.openide.util.actions.SystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.NodeAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;

import javax.swing.*;
import java.util.*;

/**
 * Defines CVS actions for top level project logical node. In
 * runtime it must be honored by project type. See convention #57874.
 *
 * <p>The menu is available only for projects that contain
 * some versionable content (source group).
 *
 * <p>Implementation of dynamic hiding is based in ToolsAction.
 *
 * @author Petr Kuzel
 * @author Maros Sandor
 *
 * @see CvsCommandsMenuItem
 */
public final class ProjectCvsMenuItem extends NodeAction implements Presenter.Popup  {

    private static final String name = NbBundle.getBundle(ProjectCvsMenuItem.class).getString("CTL_MenuItem_CVSCommands_Label");
    
    public ProjectCvsMenuItem() {
    }
    
    public String getName() {
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectCvsMenuItem.class);
    }

    protected void performAction(Node[] nodes) {
        // this item does nothing, it displays a popup
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length > 0) {
            int versionedCount = 0;
            for (int i = 0; i < nodes.length; i++) {
                Node node = nodes[i];
                if (Utils.isVersionedProject(node)) {
                    versionedCount++;
                }
            }
            return versionedCount == nodes.length || versionedCount == 0;
        }
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new CvsProjectMenuItems();
    }

    private static Action[] actions() {
        Node nodes[] = WindowManager.getDefault().getRegistry().getActivatedNodes();
        int versionedCount = 0;
        for (int i = 0; i < nodes.length; i++) {
            Node node = nodes[i];
            if (Utils.isVersionedProject(node)) {
                versionedCount++;
            }
        }

        Action [] actions;
        if (versionedCount == 0) {
            SystemAction sysAction = SystemAction.get(AddToRepositoryAction.class);
            actions = new Action[] {
                new SystemActionBridge(sysAction, sysAction.getName()),
            };
        } else {
            ResourceBundle loc = NbBundle.getBundle(ProjectCvsMenuItem.class);
            actions = new Action[] {
                new SystemActionBridge(SystemAction.get(StatusAction.class), loc.getString("CTL_ProjectMenu_Status")),
                new SystemActionBridge(SystemAction.get(DiffAction.class), loc.getString("CTL_ProjectMenu_Diff")),
                new SystemActionBridge(SystemAction.get(UpdateAction.class), loc.getString("CTL_ProjectMenu_Update")),
                new SystemActionBridge(SystemAction.get(UpdateWithDependenciesAction.class), loc.getString("CTL_ProjectMenu_UpdateWithDeps")),
                new SystemActionBridge(SystemAction.get(CommitAction.class), loc.getString("CTL_ProjectMenu_Commit")),
                null,
                new SystemActionBridge(SystemAction.get(TagAction.class), loc.getString("CTL_ProjectMenu_Tag")),
                null,
                new SystemActionBridge(SystemAction.get(BranchAction.class), loc.getString("CTL_ProjectMenu_Branch")),
                new SystemActionBridge(SystemAction.get(SwitchBranchAction.class), loc.getString("CTL_ProjectMenu_SwitchBranch")),
                new SystemActionBridge(SystemAction.get(MergeBranchAction.class), loc.getString("CTL_ProjectMenu_MergeFromBranch")),
                null,
                new SystemActionBridge(SystemAction.get(SearchHistoryAction.class), loc.getString("CTL_ProjectMenu_SearchHistory")),
                null,
                new SystemActionBridge(SystemAction.get(GetCleanAction.class), loc.getString("CTL_ProjectMenu_RevertModifications")),
                new SystemActionBridge(SystemAction.get(ResolveConflictsAction.class), loc.getString("CTL_ProjectMenu_ResolveConflicts")),
            };
        }
        return actions;
    }
    
    private static final class CvsProjectMenuItems extends JMenu {

        static final long serialVersionUID = 1L;

        private boolean popupContructed;

        public CvsProjectMenuItems() {
            Mnemonics.setLocalizedText(this, name);
        }

        public void setSelected(boolean selected) {
            if (selected && popupContructed == false) {
                // lazy submenu construction
                final Action [] actions = actions(); // expensive on first invocation
                for (int i = 0; i < actions.length; i++) {
                    Action action = actions[i];
                    if (action == null) {
                        add(new JSeparator());    // workaround openide bug
                    } else {
                        JMenuItem item = new JMenuItem(actions[i]);
                        Mnemonics.setLocalizedText(item, item.getText());
                        add(item);
                    }
                }
                popupContructed = true;
            }
            super.setSelected(selected);
        }
    }
}
