/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions;

import org.openide.util.actions.SystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.*;
import org.openide.awt.Mnemonics;
import org.netbeans.modules.versioning.system.cvss.Annotator;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * Provides the "Filesystem's" CVS actions. 
 * 
 * @author Maros Sandor
 * @see ProjectCvsMenuItem
 */
public class CvsCommandsMenuItem extends SystemAction implements ContextAwareAction  {

    private static final String name = NbBundle.getBundle(CvsCommandsMenuItem.class).getString("CTL_MenuItem_CVSCommands_Label");
    
    public CvsCommandsMenuItem() {
    }
    
    public String getName() {
        return name;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        // this item does nothing, it displays a popup
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CvsContextCommandsMenuItem(actionContext);
    }
    
    private static class CvsContextCommandsMenuItem extends AbstractAction implements Presenter.Popup {
        
        private final Lookup context;

        public CvsContextCommandsMenuItem(Lookup context) {
            super(name);
            this.context = context;
        }

        public void actionPerformed(ActionEvent e) {
            // do nothing, this is a popup menu
        }

        public JMenuItem getPopupPresenter() {
            return new CvsMenuItem();
        }

        private class CvsMenuItem extends JMenu {

            static final long serialVersionUID = 1L;

            private boolean popupContructed;

            public CvsMenuItem() {
                Mnemonics.setLocalizedText(this, name);
            }

            public void setSelected(boolean selected) {
                if (selected && popupContructed == false) {
                    // lazy submenu construction
                    final Action [] actions = Annotator.getActions(context); // expensive on first invocation
                    for (int i = 0; i < actions.length; i++) {
                        Action action = actions[i];
                        if (action == null) {
                            add(new JSeparator());    // workaround openide bug
                        } else {
                            JMenuItem item = new JMenuItem(actions[i]);
                            Mnemonics.setLocalizedText(item, item.getText());
                            add(item);
                        }
                    }
                    popupContructed = true;
                }
                super.setSelected(selected);
            }
        }

    }

}
