/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger. 
 */
package org.netbeans.modules.changelog.html;

/**
 *
 * @author  ralph
 */

import org.openide.util.*;
import javax.swing.event.*;
import javax.swing.*;
import org.netbeans.modules.changelog.*;


public class HtmlPanelCustomizer extends javax.swing.JPanel implements java.beans.Customizer {
    
    ChangeLogHTMLService service;
    private boolean disableFiring = false;
    /** Creates new form FilterPanel */
    public HtmlPanelCustomizer() {
        initComponents();
        java.awt.event.ActionListener actionList = new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setData();
            }
        };
        txCVSROOT.addActionListener(actionList);
        txDiffURL.addActionListener(actionList);
        txRevisionURL.addActionListener(actionList);
        javax.swing.event.DocumentListener docList = new javax.swing.event.DocumentListener() {
                public void insertUpdate(javax.swing.event.DocumentEvent e) {
                    setData();
                }
                public void removeUpdate(javax.swing.event.DocumentEvent e) {
                    setData();
                }
                public void changedUpdate(javax.swing.event.DocumentEvent e) {
                 //   setData();
                }
        };
        txCVSROOT.getDocument().addDocumentListener(docList);
        txDiffURL.getDocument().addDocumentListener(docList);
        txRevisionURL.getDocument().addDocumentListener(docList);
        // set the same background as the panel has..
        taExplanation.setBackground(this.getBackground());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lblDiffURL = new javax.swing.JLabel();
        txDiffURL = new javax.swing.JTextField();
        lblRevisionURL = new javax.swing.JLabel();
        txRevisionURL = new javax.swing.JTextField();
        spExplanation = new javax.swing.JScrollPane();
        taExplanation = new javax.swing.JTextArea();
        lblCVSROOT = new javax.swing.JLabel();
        txCVSROOT = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(600, 300));
        setMinimumSize(new java.awt.Dimension(400, 200));
        lblDiffURL.setText(org.openide.util.NbBundle.getBundle(HtmlPanelCustomizer.class).getString("HtmlPanel.lblDiffURL"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 6, 6);
        add(lblDiffURL, gridBagConstraints);

        txDiffURL.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 6, 12);
        add(txDiffURL, gridBagConstraints);

        lblRevisionURL.setText(org.openide.util.NbBundle.getBundle(HtmlPanelCustomizer.class).getString("HtmlPanel.lblRevisionURL.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 6, 6);
        add(lblRevisionURL, gridBagConstraints);

        txRevisionURL.setText("jTextField2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 12);
        add(txRevisionURL, gridBagConstraints);

        taExplanation.setEditable(false);
        taExplanation.setText(org.openide.util.NbBundle.getBundle(HtmlPanelCustomizer.class).getString("HtmlPanel.taExplanation.text"));
        spExplanation.setViewportView(taExplanation);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 6, 12);
        add(spExplanation, gridBagConstraints);

        lblCVSROOT.setLabelFor(txCVSROOT);
        lblCVSROOT.setText(org.openide.util.NbBundle.getBundle(HtmlPanelCustomizer.class).getString("HtmlPanel.lblCVSROOT.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 12, 6);
        add(lblCVSROOT, gridBagConstraints);

        txCVSROOT.setPreferredSize(new java.awt.Dimension(150, 20));
        txCVSROOT.setMinimumSize(new java.awt.Dimension(50, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 45;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 12, 12);
        add(txCVSROOT, gridBagConstraints);

    }//GEN-END:initComponents

    /** Set the object to be customized.  This method should be called only
     * once, before the Customizer has been added to any parent AWT container.
     * @param bean  The object to be customized.
     */
    public void setObject(Object bean) {
        if (bean instanceof ChangeLogHTMLService) {
            service = (ChangeLogHTMLService)bean;
            disableFiring = true;
            if (service.getCvsRootPrefix() != null) {
                txCVSROOT.setText(service.getCvsRootPrefix());
            } else {
                txCVSROOT.setText("");
            }
            if (service.getDiffURL() != null) {
                txDiffURL.setText(service.getDiffURL());
            } else {
                txDiffURL.setText("");
            }
            if (service.getRevisionURL() != null) {
                txRevisionURL.setText(service.getRevisionURL());
            } else {
                txRevisionURL.setText("");
            }
            disableFiring = false;
        }
    }    

    
    public void setData() {
        if (service != null && !disableFiring) {
            if (txCVSROOT.getText() != null && 
                      txCVSROOT.getText().length() > 0) {
                service.setCvsRootPrefix(txCVSROOT.getText());
            } else {
                service.setCvsRootPrefix(null);
            }
            if (txDiffURL.getText() != null && 
                      txDiffURL.getText().length() > 0) {
                service.setDiffURL(txDiffURL.getText());
            } else {
                service.setDiffURL(null);
            }
            if (txRevisionURL.getText() != null && 
                      txRevisionURL.getText().length() > 0) {
                service.setRevisionURL(txRevisionURL.getText());
            } else {
                service.setRevisionURL(null);
            }
        }
    }
    
    public void disableEditing(boolean disable) {
        txCVSROOT.setEnabled(!disable);
        txDiffURL.setEnabled(!disable);
        txRevisionURL.setEnabled(!disable);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField txDiffURL;
    private javax.swing.JLabel lblCVSROOT;
    private javax.swing.JTextField txRevisionURL;
    private javax.swing.JLabel lblRevisionURL;
    private javax.swing.JTextField txCVSROOT;
    private javax.swing.JTextArea taExplanation;
    private javax.swing.JScrollPane spExplanation;
    private javax.swing.JLabel lblDiffURL;
    // End of variables declaration//GEN-END:variables
    
}
