/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.changelog;

import java.util.*;
import java.io.File;
import java.util.zip.*;

/**
 *
 * @author  Milos Kleint, Raplh Krueger
 */
public class RevisionsGroup  {
    
    public static final int SORTING_BY_DATE = 0;
    public static final int SORTING_BY_FILE_NAME = 1;
    public static final int SORTING_BY_TYPE = 2;
    
    /** Holds value of property startingDate. */
    private Date startingDate = null;    
    
    /** Holds value of property trailingDate. */
    private Date trailingDate = null;
    
    /** Holds value of property message. */
    private String message = null;
    
    private List list;
    
    private long crcValue;
    
    /** Holds value of property user. */
    private String user;
    
    /** Holds value of property commonBranch. */
    private String commonBranch;
    
    RevisionsGroup() {
        list = new LinkedList();
        crcValue = 0;
    }
    
    /** Getter for property startingDate.
     * @return Value of property startingDate.
     */
    public Date getStartingDate() {
        return this.startingDate;
    }    
    
    /** Setter for property startingDate.
     * @param startingDate New value of property startingDate.
     */
    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }
    
    /** Getter for property trailingDate.
     * @return Value of property trailingDate.
     */
    public Date getTrailingDate() {
        return this.trailingDate;
    }
    
    /** Setter for property trailingDate.
     * @param trailingDate New value of property trailingDate.
     */
    public void setTrailingDate(Date trailingDate) {
        this.trailingDate = trailingDate;
    }

    /** Getter for property message.
     * @return Value of property message.
     */
    public String getMessage() {
        return this.message;
    }
    
    /** Setter for property message.
     * @param message New value of property message.
     */
    public void setMessage(String message) {
        this.message = message;
    }
    /** Getter for property user.
     * @return Value of property user.
     */
    public String getUser() {
        return this.user;
    }
    
    /** Setter for property user.
     * @param user New value of property user.
     */
    public void setUser(String user) {
        this.user = user;
    }
    
    public void addRevision(LogInfoRevision rev, String newMessage) {
        if (getStartingDate() == null || rev.getDate().before(getStartingDate())) {
            setStartingDate(rev.getDate());
        }
        if (getTrailingDate() == null || rev.getDate().after(getTrailingDate())) {
            setTrailingDate(rev.getDate());
        }
        if (message == null) {
            //first revision is added.
            setMessage(newMessage);
            setCRC32(computeCRC32(newMessage));
            if (!rev.getBranch().equals("")) {
                setCommonBranch(rev.getBranch());
            }
        } else {
            if (getCommonBranch() != null) {
                if (!getCommonBranch().equals(rev.getBranch())) {
                    // not all revisions are on the same branch..
                    // reset common branch..
                    setCommonBranch(null);
                }
            }
        }
        
        if (user == null) {
            setUser(rev.getAuthor());
        }
        list.add(rev);
    }
    
    
    public static long  computeCRC32(String message) {
        CRC32 crc = new CRC32();
        byte[] bytes = message.getBytes();
        crc.update(bytes);
        return crc.getValue();
    }
    
    void setCRC32(long crcValue) {
        this.crcValue = crcValue;
    }
    
    public long getCRC32() {
        return crcValue;
    }
    
    public List getList() {
        return list;
    }
    
    public List getSortedList(int sortingField) {
        //TODO
        return list;
    }
    
    /** Getter for property commonBranch.
     * @return Value of property commonBranch.
     */
    public String getCommonBranch() {
        return this.commonBranch;
    }    
    
    /** Setter for property commonBranch.
     * @param commonBranch New value of property commonBranch.
     */
    void setCommonBranch(String commonBranch) {
        this.commonBranch = commonBranch;
    }
    
    private static class FileNameRevComparator implements Comparator {
        
        public int compare(Object obj, Object obj1) {
            LogInfoRevision rev1 = (LogInfoRevision)obj;
            LogInfoRevision rev2 = (LogInfoRevision)obj1;
            File file1 = rev1.getLogInfoHeader().getFile();
            File file2 = rev2.getLogInfoHeader().getFile();
            return file1.compareTo(file2);
        }
    }
    
    private static class TypeRevComparator implements Comparator {
        
        public int compare(Object obj, Object obj1) {
            //TODO..
            return 1;
        }
        
    }
    
    public static class GroupDateComparator implements Comparator {
        
        private int descending;

        public GroupDateComparator(boolean descending) {
            this.descending = descending ? -1 : 1;
        }
        
        public int compare(Object obj, Object obj1) {
            if (!(obj instanceof RevisionsGroup) ||
                !(obj1 instanceof RevisionsGroup)) {
               return 0;
            }
            RevisionsGroup gr1 = (RevisionsGroup)obj;
            RevisionsGroup gr2 = (RevisionsGroup)obj1;
            if (gr1.getStartingDate() == null) {
                return -1 * descending;
            }
            if (gr2.getStartingDate() == null) {
                return 1 * descending;
            }
            if (gr1.getStartingDate().before(gr2.getStartingDate())) {
                return -1 * descending;
            }
            if (gr1.getStartingDate().after(gr2.getStartingDate())) {
                return 1 * descending;
            }
            return 0;
        }
    }    

    
    public static class UserDateComparator implements Comparator {
        
        private int descending;
        private GroupDateComparator innerComp;

        public UserDateComparator() {
            this(false);
        }
        
        public UserDateComparator(boolean descending) {
            this.descending = descending ? -1 : 1;
            innerComp = new RevisionsGroup.GroupDateComparator(false);
        }
        
        public int compare(Object obj, Object obj1) {
            if (!(obj instanceof RevisionsGroup) ||
                !(obj1 instanceof RevisionsGroup)) {
               return 0;
            }
            RevisionsGroup gr1 = (RevisionsGroup)obj;
            RevisionsGroup gr2 = (RevisionsGroup)obj1;
            if (gr1.getUser() == null) {
                return -1 * descending;
            }
            if (gr2.getUser() == null) {
                return 1 * descending;
            }
            int toReturn = gr1.getUser().compareTo(gr2.getUser()) * descending;
            if (toReturn == 0) {
                toReturn = innerComp.compare(obj, obj1);
            }
            return toReturn;
        }
    }    
    
}
