/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.changelog;

import java.io.*;
import java.text.*;
import java.util.*;

import org.netbeans.modules.vcscore.ui.views.*;
import org.openide.nodes.*;

/**
 * @author  Milos Kleint, Ralph
 */

public class LogInfoRevision extends FileVcsInfo {
    
    private static final String NUMBER    = "rev-Number";
    private static final String DATE      = "date";
    private static final String AUTHOR    = "author";
    private static final String STATE     = "state";
    private static final String LINES     = "lines";
    private static final String BRANCH    = "branch";
    private static final String HEADER    = "header";
    
    public LogInfoRevision(File file) {
        super(file, "ChangeLogInfo", Children.LEAF);
    }
    
    
    public String getNumber() {
        return getAttributeNonNull(NUMBER);
    }
    
    /**
     * Sets the number of revision..
     */
    public void setNumber(String number) {
        setAttribute(NUMBER, number);
    }
    
    public Date getDate() {
        return (Date)getAttribute(DATE);
    }
    
    
    public void setDate(Date newDate) {
        setAttribute(DATE, newDate);
    }
    
    public String getAuthor() {
        return getAttributeNonNull(AUTHOR);
    }
    
    public void setAuthor(String author) {
        setAttribute(AUTHOR, author);
    }
    
    public String getState() {
        return getAttributeNonNull(STATE);
    }
    
    public void setState(String state) {
        setAttribute(STATE, state);
    }
    
    public String getLines() {
        return getAttributeNonNull(LINES);
    }
    
    public void setLines(String lines) {
        setAttribute(LINES, lines);
    }
    
    /**
     * Returns how many lines were added in this revision.
     */
    public int getAddedLines() {
        String lines = (String)getAttribute(LINES);
        if (lines != null) {
            int start = lines.indexOf('+');
            int end = lines.indexOf(' ');
            if (start >= 0 && end > start) {
                String added = lines.substring(start + 1, end);
                try {
                    int toReturn = Integer.parseInt(added);
                    return toReturn;
                } catch (NumberFormatException exc) {
                    //TODO BUGLog..
                }
            }
        }
        return 0;
    }
    
    public int getRemovedLines() {
        String lines = (String)getAttribute(LINES);
        if (lines != null) {
            int start = lines.indexOf('-');
            if (start >= 0) {
                String removed = lines.substring(start + 1);
                try {
                    int toReturn = Integer.parseInt(removed);
                    return toReturn;
                } catch (NumberFormatException exc) {
                    //TODO BUGLog..
                }
            }
        }
        return 0;
        
    }

    /**
     * Returns the branch on which the change was done.
     * Empty String when no branch..
     */
    
    public String getBranch() {
        return getAttributeNonNull(BRANCH);
    }
    
    /**
     * Specifies the branch on which the change was done.
     */
    
    public void setBranch(String branch) {
        setAttribute(BRANCH, branch);
    }
    
    /**
     * sets class that represents the file-related  information that
     * belongs to the revision..
     * Warning: for optimalization reasons, make sure that all revisions
     * belonging to a file have the same instance of LogInfoHeader.
     * The number of revisions can be quite high and memory consumption 
     * might become a problem..
     */
    public void setLogInfoHeader(LogInfoHeader header) {
        setAttribute(HEADER, header);
    }
    
    
    public LogInfoHeader getLogInfoHeader() {
        return (LogInfoHeader)getAttribute(HEADER);
    }
    
    
    public static class LogInfoHeader {
        private File file;
        private String repositoryFilename;
        private String headRevision;
        private String branch;
        private String accessList;
        private String keywordSubstitution;
        private String totalRevisions;
        private String selectedRevisions;
        private String description;
        private String locks;
        
        public LogInfoHeader() {
        }
        
        /** Getter for property file.
         * @return Value of property file.
         */
        public File getFile() {
            return file;
        }
        
        /** Setter for property file.
         * @param file New value of property file.
         */
        public void setFile(File file) {
            this.file = file;
        }
        
        /** Getter for property repositoryFilename.
         * @return Value of property repositoryFilename.
         */
        public String getRepositoryFilename() {
            return repositoryFilename;
        }
        
        /** Setter for property repositoryFilename.
         * @param repositoryFilename New value of property repositoryFilename.
         */
        public void setRepositoryFilename(String repositoryFilename) {
            this.repositoryFilename = repositoryFilename;
        }
        
        /** Getter for property headRevision.
         * @return Value of property headRevision.
         */
        public String getHeadRevision() {
            return headRevision;
        }
        
        /** Setter for property headRevision.
         * @param headRevision New value of property headRevision.
         */
        public void setHeadRevision(String headRevision) {
            this.headRevision = headRevision;
        }
        
        /** Getter for property branch.
         * @return Value of property branch.
         */
        public String getBranch() {
            return branch;
        }
        
        /** Setter for property branch.
         * @param branch New value of property branch.
         */
        public void setBranch(String branch) {
            this.branch = branch;
        }
        
        /** Getter for property accessList.
         * @return Value of property accessList.
         */
        public String getAccessList() {
            return accessList;
        }
        
        /** Setter for property accessList.
         * @param accessList New value of property accessList.
         */
        public void setAccessList(String accessList) {
            this.accessList = accessList;
        }
        
        /** Getter for property keywordSubstitution.
         * @return Value of property keywordSubstitution.
         */
        public String getKeywordSubstitution() {
            return keywordSubstitution;
        }
        
        /** Setter for property keywordSubstitution.
         * @param keywordSubstitution New value of property keywordSubstitution.
         */
        public void setKeywordSubstitution(String keywordSubstitution) {
            this.keywordSubstitution = keywordSubstitution;
        }
        
        /** Getter for property totalRevisions.
         * @return Value of property totalRevisions.
         */
        public String getTotalRevisions() {
            return totalRevisions;
        }
        
        /** Setter for property totalRevisions.
         * @param totalRevisions New value of property totalRevisions.
         */
        public void setTotalRevisions(String totalRevisions) {
            this.totalRevisions = totalRevisions;
        }
        
        /** Getter for property selectedRevisions.
         * @return Value of property selectedRevisions.
         */
        public String getSelectedRevisions() {
            return selectedRevisions;
        }
        
        /** Setter for property selectedRevisions.
         * @param selectedRevisions New value of property selectedRevisions.
         */
        public void setSelectedRevisions(String selectedRevisions) {
            this.selectedRevisions = selectedRevisions;
        }
        
        /** Getter for property description.
         * @return Value of property description.
         */
        public String getDescription() {
            return description;
        }
        
        /** Setter for property description.
         * @param description New value of property description.
         */
        public void setDescription(String description) {
            this.description = description;
        }
        
        /** Getter for property locks.
         * @return Value of property locks.
         */
        public String getLocks() {
            return locks;
        }
        
        /** Setter for property locks.
         * @param locks New value of property locks.
         */
        public void setLocks(String locks) {
            this.locks = locks;
        }
        
    }
    
    
    
}



