/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.parsing.javadoc;

import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.java.LogTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;


import org.openide.src.ClassElement;


public class JavaDoc extends LogTestCase {
    
    ClassElement clazz;
    /** Need to be defined because of JUnit */
    public JavaDoc(String name) {
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new JavaDoc("testClass"));
        suite.addTest(new JavaDoc("testMethod"));
        suite.addTest(new JavaDoc("testField"));
        suite.addTest(new JavaDoc("testConstructor"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    public void setUp() {
        super.setUp();
        FileObject artefact=FileUtil.toFileObject(classPathWorkDir);
        clazz = ClassElement.forName(getClass().getPackage().getName()+".TestFile", artefact);
    }
    
    public void testClass() {
        ref(clazz.getJavaDoc().getRawText());
    }
    
    public void testMethod() {
        ref(clazz.getMethods()[0].getJavaDoc().getRawText());
    }
    
    public void testField() {
        ref(clazz.getFields()[0].getJavaDoc().getRawText());
    }

    public void testConstructor() {
        ref(clazz.getConstructors()[0].getJavaDoc().getRawText());
    }
}
