/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ForName.java
 *
 * Created on September 19, 2000, 1:39 PM
 */

package org.netbeans.test.java.integrity.GetClass;

import org.openide.filesystems.FileUtil;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;


/** <B>Java Module Integrity API Test: GetClass</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Capability of module to find class (inner or outer) in .java file.
 * <BR><BR><I>What has to be set:</I><BR>
 * testbase/testfs has to be mounted.
 * <BR><BR><I>How it works:</I><BR>
 * Test tries to find known classes using ClassElement.getClass() and SourceElement.getClass();
 * <BR><BR><I>Output:</I><BR>
 * Places, where were known classes found. This is compared with golden file.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>Some classes were not found</U><BR>
 * See .diff file which ones.
 * <BR><BR><U>Exception occured:</U><BR>
 * See .out or .diff file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 * @version
 */


public class GetClass extends org.netbeans.test.java.LogTestCase   {
    
    
    public void testRun() {
        
        try {
            _testIt();
        } catch (Exception e) {
            assertTrue(e.toString(), false);
        }
    }
    
    public GetClass(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(GetClass.class);
    }
    
    public void _testIt() throws Exception {
        
        
        ClassElement ce = ClassElement.forName("org.netbeans.test.java.testsources.GetClassTest", FileUtil.toFileObject(classPathWorkDir));
        org.openide.src.SourceElement se = ce.getSource();
        
        ClassElement ce1, ce2;
        
        //SN
        ce1 = se.getClass(Identifier.create("GetClassTest"));
        ce2 = ce1.getClass(Identifier.create("InnerClass2"));
        if (ce1==null){
            ref("null: GetClassTest not found!");
        } else {
            ref(ce1.getName().getFullName());
        }
        if (ce2==null){
            ref("null: NewClass2 not found!");
        } else {
            ref(ce2.getName().getFullName());
        }
        
        
        //FQN
        ce1 = se.getClass(Identifier.create("org.netbeans.test.java.testsources.NewClass3","NewClass3"));
        ce2 = ce1.getClass(Identifier.create("org.netbeans.test.java.testsources.NewClass3.InnerClass1","InnerClass1"));
        if (ce1 == null){
            ref("null: GetClassTest not found!");
        } else {
            ref(ce1.getName().getFullName());
        }
        if (ce2==null){
            ref("null: NewClass3 not found!");
        } else {
            ref(ce2.getName().getFullName());
        }
        
        //FQN is bad! => should return null
        ce1 = se.getClass(Identifier.create("org.netbeans.test.java.testsources.GetClssTest","GetClassTest"));
        ce2 = ce.getClass(Identifier.create("org.netbeans.test.java.testsources.GetClssTest.InnerClass1","InnerClass1"));
        
        if (ce1 == null){
            ref("null - OK");
        } else {
            ref("Not null! but should be null!");
        }
        if (ce2==null){
            ref("null - OK");
        } else {
            ref("Not null! but should be null!");
        }
    }
    
}
