/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.gui.synchronization;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.modules.java.SynchronizeOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.java.Utilities;
import org.netbeans.test.java.gui.GuiUtilities;


/**
 * Tests Synchronize dialog.
 * @author Roman Strobl
 */
public class SynchronizeDialog extends JellyTestCase {
    
    // name of sample project
    private static final String TEST_PROJECT_NAME = "default";
    
    // path to sample files
    private static final String TEST_PACKAGE_PATH =
            "org.netbeans.test.java.gui.synchronization";
    
    // name of sample package
    private static final String TEST_PACKAGE_NAME = TEST_PACKAGE_PATH+".test";
    
    // name of sample class
    private static final String TEST_CLASS_NAME = "TestClass";
    
    /**
     * error log
     */
    protected static PrintStream err;
    /**
     * standard log
     */
    protected static PrintStream log;
    
    // workdir, default /tmp, changed to NBJUnit workdir during test
    private String workDir = "/tmp";
    
    // actual directory with project
    private static String projectDir;
    
    /** Needs to be defined because of JUnit
     * @param name name of testsuite
     */
    public SynchronizeDialog(String name) {
        super(name);
    }
    
    /**
     * The test suite
     * @return suite
     */
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new SynchronizeDialog("testSynchronizeDialog"));
        return suite;
    }
    
    /**
     * Use for execution inside IDE
     * @param args no command line arguments
     */
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        err = getLog();
        log = getRef();
        JemmyProperties.getProperties().setOutput(new TestOut(null,
                new PrintWriter(err, true), new PrintWriter(err, false), null));
        try {
            File wd = getWorkDir();
            workDir = wd.toString();
        } catch (IOException e) { }
    }
    
    /**
     * Prepares testing project, package and class.
     */
    public void testCreateProjectAndPackageAndClass() {
        projectDir = GuiUtilities.createProjectAndPackageAndClass(
                TEST_PROJECT_NAME, TEST_PACKAGE_NAME, TEST_CLASS_NAME, workDir);
    }    
    
    /**
     * Executes the main test.
     */
    public void testSynchronizeDialog() {        
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();

        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        
        n.select();
        new OpenAction().perform();       
        
        // add implements Runnable to code
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("implements Runnable ", 11, 24);
        editor.save();
        
        Utilities.takeANap(1000);

        // open Synchronize dialog
        pn.select();
        Node n2 = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        n2.select();
        n2.performPopupActionNoBlock(
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.core.Bundle", "Actions/Tools")+"|"+
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.Bundle", "LAB_SynchronizeAction"));
        
        Utilities.takeANap(1000);
        
        // process synchronization
        new JDialogOperator(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.Bundle", "LAB_ConfirmDialog"));
        
        SynchronizeOperator sdo = new SynchronizeOperator();
        
        sdo.lstChangesList().selectItem(0);
        sdo.btProcess().clickMouse();
                               
        ref(editor.getText());
        
        compareReferenceFiles();        
        
        EditorOperator.closeDiscardAll();
    }
    
}
