/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.gui.parser;

import java.awt.event.KeyEvent;
import org.netbeans.junit.*;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.nodes.*;
import org.netbeans.jellytools.actions.*;

import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.test.java.gui.GuiUtilities;

import java.io.*;

/**
 * Tests Java Parser.
 * @author Roman Strobl
 */
public class ParserTest extends JellyTestCase {

    // name of sample project
    private static final String TEST_PROJECT_NAME = "default";
    
    // path to sample files
    private static final String TEST_PACKAGE_PATH =
            "org.netbeans.test.java.gui.parser";
    
    // name of sample package
    private static final String TEST_PACKAGE_NAME = TEST_PACKAGE_PATH+".test";
    
    // name of sample class
    private static final String TEST_CLASS_NAME = "TestClass";
    
    // name of sample inner interface
    private static final String TEST_INNER_CLASS_NAME = 
            "TestInnerClass"; 
    
    // name of sample inner interface
    private static final String TEST_INNER_INTERFACE_NAME = 
            "TestInnerInterface"; 

    // name of sample parameter
    private static final String TEST_PARAMETER_NAME = 
            "TestParameter"; 

    // name of sample filed
    private static final String TEST_FIELD_NAME = 
            "TestField"; 

    // name of sample method
    private static final String TEST_METHOD_NAME = 
            "TestMethod"; 
    
    // name of sample outer interface
    private static final String TEST_OUTER_CLASS_NAME = 
            "TestOuterClass"; 
    
    // name of sample outer interface
    private static final String TEST_OUTER_INTERFACE_NAME = 
            "TestOuterInterface"; 
    
    /**
     * error log
     */
    protected static PrintStream err;
    /**
     * standard log
     */
    protected static PrintStream log;
   
    // workdir, default /tmp, changed to NBJUnit workdir during test
    private String workDir = "/tmp";
    
    private static String projectDir;
    
    /**
     * Adds tests into the test suite.
     * @return suite
     */
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new ParserTest("testCreateInnerClass"));
        suite.addTest(new ParserTest("testCreateInnerInterface"));
        suite.addTest(new ParserTest("testCreateConstructor"));
        suite.addTest(new ParserTest("testCreateField"));
        suite.addTest(new ParserTest("testCreateOuterClass"));
        suite.addTest(new ParserTest("testCreateOuterInterface"));
        return suite;
    }

     /**
     * Main method for standalone execution.
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }        
    
    /**
     * Sets up logging facilities.
     */
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        err = getLog();
        log = getRef();        
        JemmyProperties.getProperties().setOutput(new TestOut(null, 
                new PrintWriter(err, true), new PrintWriter(err, false), null));
        try {
            File wd = getWorkDir();
            workDir = wd.toString();
        } catch (IOException e) { }        
    }
    
    /** 
     * Creates a new instance of ParserTest
     * @param testName name of test
     */
    public ParserTest(String testName) {
        super(testName);
    }
       
    /**
     * Tests parsing of inner class.
     */
    public void testCreateInnerClass() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();

        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        
        n.select();
        new OpenAction().perform();
        
        // add inner class
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("public class "+TEST_INNER_CLASS_NAME
                +" { }\n", 18, 1);
     
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();

        // choose node which should appear in projects tab
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME, 
                TEST_INNER_CLASS_NAME);
                
        Node n2 = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +TEST_INNER_CLASS_NAME); 
        n2.select();
    }

    /**
     * Tests parsing of inner interface.
     */
    public void testCreateInnerInterface() {
        // add public interface
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("public interface "+TEST_INNER_INTERFACE_NAME
                +" { }\n", 19, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();
        
        // choose node which should appear in projects tab
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME,
                TEST_INNER_INTERFACE_NAME);
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +TEST_INNER_INTERFACE_NAME);
        n.select(); 
    }

    /**
     * Tests parsing of constructor.
     */
    public void testCreateConstructor() {
        // add constructor
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("public "+TEST_CLASS_NAME+"(String "+TEST_PARAMETER_NAME
                +") { }\n", 20, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();
        
        // choose node which should appear in projects tab        
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +"Constructors", TEST_CLASS_NAME+"(String)");
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"+"Constructors"+"|"
                +TEST_CLASS_NAME+"(String)"); 
        n.select(); 
    }

    /**
     * Tests parsing of a field.
     */
    public void testCreateField() {
        // add a String field
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("String "+TEST_FIELD_NAME+";\n", 21, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();  

        // choose node which should appear in projects tab        
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +"Fields", TEST_FIELD_NAME);
                
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"+"Fields"+"|"
                +TEST_FIELD_NAME); 
        n.select(); 
    }

    /**
     * Tests parsing of a method.
     */
    public void testCreateMethod() {
        // add a method
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("private int "+TEST_METHOD_NAME+"(Object "
                +TEST_PARAMETER_NAME+") { }\n", 22, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();  

        // choose node which should appear in projects tab
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +"Methods", TEST_METHOD_NAME);
                
                
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"+"Methods"+"|"
                +TEST_METHOD_NAME); 
        n.select(); 
    }
    
    /**
     * Tests parsing of outer class.
     */
    public void testCreateOuterClass() {
        // add an outer class
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("public class "+TEST_OUTER_CLASS_NAME
                +" { }\n", 23, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();  

        // choose node which should appear in projects tab        
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME, TEST_OUTER_CLASS_NAME);
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_OUTER_CLASS_NAME); 
        n.select(); 
    }
    
    /**
     * Tests parsing of outer interface.
     */
    public void testCreateOuterInterface() {
        // add an outer interface
        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        editor.insert("public interface "+TEST_OUTER_INTERFACE_NAME
                +" { }\n", 24, 1);
        
        SaveAction saveAction = new SaveAction();
        MainWindowOperator.getDefault().menuBar().showMenuItem(saveAction.getMenuPath());
        MainWindowOperator.getDefault().pushKey(KeyEvent.VK_ESCAPE);        
        saveAction.perform();  

        // choose node which should appear in projects tab        
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();
        
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, 
                org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME, TEST_OUTER_INTERFACE_NAME);
        
        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle", 
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_OUTER_INTERFACE_NAME); 
        n.select(); 
    }
        
}
