/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.java.gui.customizers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.textui.TestRunner;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.modules.java.MethodCustomizerOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.properties.Property;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.java.gui.GuiUtilities;


/**
 * Tests editing parameters of a method in a pop-up window.
 * @author Roman Strobl
 */
public class MethodCustomizer extends JellyTestCase {
       
    // name of sample project
    private static final String TEST_PROJECT_NAME = "default";
    
    // path to sample files
    private static final String TEST_PACKAGE_PATH =
            "org.netbeans.test.java.gui.customizers";
    
    // name of sample package
    private static final String TEST_PACKAGE_NAME = TEST_PACKAGE_PATH+".test";
    
    // name of sample class
    private static final String TEST_CLASS_NAME = "MethodCustomizer";

    // name of sample method
    private static final String TEST_METHOD_NAME = "TestMethod"; 

    /**
     * error log
     */
    protected static PrintStream err;
    
    /**
     * standard log
     */
    protected static PrintStream log;
   
    // workdir, default /tmp, changed to NBJUnit workdir during test
    private String workDir = "/tmp";
    
    // actual directory with project
    private static String projectDir;    
    
    /**
     * Needs to be defined because of JUnit
     * @param name test name
     */
    public MethodCustomizer(String name) {
        super(name);
    }

    /**
     * Adds tests into the test suite.
     * @return suite
     */    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new MethodCustomizer("testCustomizeMethod"));
        return suite;
    }
    
    /**
     * Main method for standalone execution.
     * @param args the command line arguments
     */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }
    
    /**
     * Sets up logging facilities.
     */
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        err = getLog();
        log = getRef();        
        JemmyProperties.getProperties().setOutput(new TestOut(null, 
                new PrintWriter(err, true), new PrintWriter(err, false), null));
        try {
            File wd = getWorkDir();
            workDir = wd.toString();
        } catch (IOException e) { }        
    }
    
    /**
     * Tests method customizer.
     */
    public void testCustomizeMethod() {
        Node pn = new ProjectsTabOperator().getProjectRootNode(
                TEST_PROJECT_NAME);
        pn.select();

        Node n = new Node(pn, org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.j2seproject.Bundle",
                "NAME_src.dir")+"|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME);
        
        n.select();
        new OpenAction().perform();

        EditorOperator editor = new EditorOperator(TEST_CLASS_NAME);
        
        // type a method into code
        editor.insert("String "+TEST_METHOD_NAME+"(){ };\n", 14, 5);       
                
        // open method properties window
        GuiUtilities.waitForChildNode(TEST_PROJECT_NAME, "Source Packages|"
                +TEST_PACKAGE_NAME+"|"+TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", 
                "Methods"), TEST_METHOD_NAME);

        Node n2 = new Node(pn, "Source Packages|"+TEST_PACKAGE_NAME+"|"
                +TEST_CLASS_NAME+"|"+TEST_CLASS_NAME+"|"
                +org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.modules.java.ui.nodes.elements.Bundle", "Methods")
                +"|"+TEST_METHOD_NAME); // NOI18N
        

        n2.select();                
        n2.performPopupActionNoBlock(org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.core.Bundle", "CTL_PropertiesWindow"));
        
        MethodCustomizerOperator cco = new MethodCustomizerOperator(
                TEST_METHOD_NAME+" - "+org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.core.Bundle", "CTL_PropertiesWindow"));
        
        PropertySheetOperator pso = new PropertySheetOperator(TEST_METHOD_NAME
                +" - "+org.netbeans.jellytools.Bundle.getString(
                "org.netbeans.core.Bundle", "CTL_PropertiesWindow"));
        
        // try to set some values to see if customization works
        new Property(pso, "Modifiers").setValue("private");
        new Property(pso, "Return Type").setValue("void");
        new Property(pso, "Exceptions").setValue("Exception");
                
        cco.btClose().clickMouse();

        // compare reference files
        ref(editor.getText());
        compareReferenceFiles();
        
        EditorOperator.closeDiscardAll();
    }
    
}
