/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldElem.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.generating.SourceElem;

import org.netbeans.test.java.Common;
import org.openide.src.*;
import java.lang.reflect.Modifier;
import org.netbeans.junit.*;

/** <B>Java Module General API Test: SourceElement</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Creating and handling with SourceElement.
 * Test is focused on checking of correctness of generated code.
 * <BR><BR><I>How it works:</I><BR>
 * New class is created using DataObject.createFromTemplate().
 * This SourceElement is then customized using setters. Some classes are inserted.
 * These actions cause generating of .java code. This code is compared with supposed one.
 * <BR><BR><I>Output:</I><BR>
 * Generated Java code.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>SourceElement have/return bad properties</U><BR>
 * See .diff file to get which ones
 * <BR><BR><U>Bad indentation</U><BR>
 * This is probably not a bug of Java Module. (Editor Bug)
 * In .diff file could be some whitespaces.
 * <BR><BR><U>Exception occured:</U><BR>
 * See .log file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class SourceElem extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public SourceElem() {
        super("");
    }
    
    public SourceElem(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(SourceElem.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.SourceElement source = (org.openide.src.SourceElement) o;
        boolean passed = true;
        
            Import[] imports = new Import[] {
            new Import(Identifier.create("java.awt.image.RGBImageFilter"),false),
            new Import(Identifier.create("javax.swing.event.HyperlinkEvent"),false),
            new Import(Identifier.create("javax.swing"),true)
        };
        
        source.addImports(imports);
        
        if (source.getImports().length!=3){
            passed = false;
            log("getImports() failed");
        }
        
        source.addImport(new Import(Identifier.create("java.awt"),true));
        
        if (!source.getImports()[1].getIdentifier().toString().equals("java.awt.image.RGBImageFilter")){
            passed = false;
            log("getImports() failed");
        }
        
        source.removeImport(source.getImports()[1]);
        
        for (int i=0;i<100;i++){
            source.setPackage(Identifier.create(Common.concat("somepackage",i)));
            source.prepare().waitFinished();
            if (source.getStatus()!=org.openide.src.SourceElement.STATUS_OK){
            passed = false;
            log("setPackage failed");
            }
            if (!source.getPackage().toString().equals(Common.concat("somepackage",i))){
            passed = false;
            log("setPackage failed");
            }
        }
        
        if (!source.getPackage().toString().equals("somepackage99")){
            passed = false;
            log("getPackage() failed");
        }
        
        ClassElement ce = new ClassElement();
        
        ce.setName(Identifier.create("newClass1"));
        source.addClass(ce);
        ce.setName(Identifier.create("newClass2"));
        source.addClass(ce);
        
        ClassElement[] ces = new ClassElement[] {
            new ClassElement(),
            new ClassElement()
        };
        
        ces[0].setName(Identifier.create("newClass3"));
        ces[1].setName(Identifier.create("newClass4"));
        
        source.addClasses(ces);
        
        if (source.getClasses().length !=5) {
            passed = false;
            log("getClasses() failed");
        }
        
        source.removeClass(source.getClass(Identifier.create("newClass2")));
        source.removeClasses(new ClassElement[] {source.getClass(Identifier.create("newClass4"))});
    
        return passed;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceSourceElem";
        packageName = "org.netbeans.test.java.testsources";
    }
    
}
