/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldElem.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.generating.MethodElem;

import org.netbeans.test.java.Common;
import org.openide.src.*;
import java.lang.reflect.Modifier;
import org.netbeans.junit.*;

/** <B>Java Module General API Test: MethodElement</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Creating and handling with MethodElement.
 * Test is focused on checking of correctness of generated code.
 * <BR><BR><I>How it works:</I><BR>
 * New class is created using DataObject.createFromTemplate() and also some MethodElements are created.
 * These are customized using setters and then added using ClassElement.addMethod() into ClassElement.
 * These actions cause generating of .java code. This code is compared with supposed one.
 * <BR><BR><I>Output:</I><BR>
 * Generated Java code.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <U>Methods are not inserted properly</U><BR>
 * If there are some Interfaces in .diff file.
 * <BR><BR><U>Methods have/return bad properies</U><BR>
 * See .diff file to get which ones
 * <BR><BR><U>Bad indentation</U><BR>
 * This is probably not a bug of Java Module. (Editor Bug)
 * In .diff file could be some whitespaces.
 * <BR><BR><I>Exception occured:</I><BR>
 * See .log file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class MethodElem extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public MethodElem() {
        super("");
    }
    
    public MethodElem(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(MethodElem.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        boolean passed = true;
        
        clazz.addMethod(Common.createMethod("method1", Modifier.PUBLIC | Modifier.STATIC, Type.VOID, Common.PARS1));
        clazz.addMethod(Common.createMethod("method1", Modifier.PRIVATE | Modifier.SYNCHRONIZED, Type.INT, Common.PARS2));
        clazz.addMethod(Common.createMethod("method1", Modifier.PUBLIC | Modifier.FINAL, Type.FLOAT, Common.PARS3));
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.DOUBLE, Common.PARS1));
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.BOOLEAN, Common.PARS2));
        clazz.addMethod(Common.createMethod("method2", Modifier.PUBLIC | Modifier.STATIC, Type.VOID, Common.PARS3));
        org.openide.src.MethodElement me;
        
        me=clazz.getMethod(Identifier.create("method1"),new Type[] {Type.INT});
        
        if (me==null) {
            passed = false;
            log("Method not found");
        } else {
            if (!me.getName().equals(Identifier.create("method1"))){
                passed = false;
                log("getName failed");
            }
            if (!(me.getModifiers()==(Modifier.PUBLIC| Modifier.STATIC))){
                passed = false;
                log("getModifiers failed");
            }
            if (!me.getReturn().equals(Type.VOID)){
                passed = false;
                log("getReturn failed");
            }
            if (!(me.getDeclaringClass().getName().getName().equals(name))){
                passed = false;
                log("getDeclaringClass failed");
            }
            if (!Common.arrayEquals(me.getParameters(),Common.PARS1)){
                passed = false;
                log("getParameters failed");
            }
        }
        
        org.openide.src.MethodElement[] methodsToRemove1 = new org.openide.src.MethodElement[3];
        methodsToRemove1[0] = clazz.getMethod(Identifier.create("method1"),Common.TPARS1);
        methodsToRemove1[1] = clazz.getMethod(Identifier.create("method2"),Common.TPARS1);
        methodsToRemove1[2] = clazz.getMethod(Identifier.create("method2"),Common.TPARS3);
        clazz.removeMethods(methodsToRemove1);
        
        me = clazz.getMethod(Identifier.create("method2"),Common.TPARS2);
        me.setName(Identifier.create("renamedMethod2"));
        me.setParameters(Common.PARS3);
        me.setReturn(Type.FLOAT);
        me.setModifiers(Modifier.SYNCHRONIZED | Modifier.PRIVATE);
        
        return passed;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceMethodElem";
        packageName = "org.netbeans.test.java.testsources";
    }
    
}
